/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.currency;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;

public class CurrencyNames {
    private static final String BUNDLE_NAME = "/net/yapbam/currency/currencyNames";
    private static Properties RESOURCE_BUNDLE;
    private static Locale resourceBundleLocale;

    private CurrencyNames() {
    }

    public static String get(String key) {
        CurrencyNames.reset();
        String wording = (String)RESOURCE_BUNDLE.get(key);
        return wording == null ? key : wording;
    }

    private static void reset() {
        if (!Locale.getDefault().equals(resourceBundleLocale)) {
            Properties properties = new Properties();
            String lang = Locale.getDefault().getLanguage();
            String resourceSuffix = ".properties";
            boolean ok = false;
            try {
                ok = CurrencyNames.tryLoading(properties, "/net/yapbam/currency/currencyNames_" + lang + resourceSuffix);
                if (!ok) {
                    ok = CurrencyNames.tryLoading(properties, BUNDLE_NAME + resourceSuffix);
                }
            }
            catch (IOException e) {
                ok = false;
            }
            if (!ok) {
                throw new MissingResourceException("", "", BUNDLE_NAME);
            }
            RESOURCE_BUNDLE = properties;
            resourceBundleLocale = Locale.getDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryLoading(Properties properties, String name) throws IOException {
        InputStream stream = CurrencyNames.class.getResourceAsStream(name);
        if (stream == null) {
            return false;
        }
        try {
            boolean bl;
            InputStreamReader reader = new InputStreamReader(stream, "ISO8859-1");
            try {
                properties.load(reader);
                bl = true;
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
            return bl;
        }
        finally {
            stream.close();
        }
    }
}

