/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.yapbam.data.Account;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.SubTransaction;

public abstract class AbstractTransaction
implements Cloneable {
    private static final AtomicLong CURRENT_ID = new AtomicLong();
    private long id;
    private String description;
    private String comment;
    private double amount;
    private Account account;
    private Mode mode;
    private Category category;
    private List<SubTransaction> subTransactions;

    private static void setId(AbstractTransaction transaction) {
        long id = CURRENT_ID.getAndIncrement();
        if (id < 0L) {
            throw new RuntimeException("Transaction counter has an overflow");
        }
        transaction.id = id;
    }

    public AbstractTransaction(String description, String comment, double amount, Account account, Mode mode, Category category, List<SubTransaction> subTransactions) {
        if (mode == null || category == null || description == null) {
            throw new IllegalArgumentException();
        }
        this.description = this.getCachedDescription(description);
        if (comment != null && comment.isEmpty()) {
            comment = null;
        }
        this.comment = comment;
        this.amount = amount;
        this.account = account;
        this.mode = mode;
        this.category = category;
        this.subTransactions = subTransactions != null ? subTransactions : Collections.emptyList();
        AbstractTransaction.setId(this);
    }

    private String getCachedDescription(String description) {
        return description;
    }

    public Object clone() {
        AbstractTransaction result = null;
        try {
            result = (AbstractTransaction)super.clone();
            result.subTransactions = new ArrayList<SubTransaction>();
            for (int i = 0; i < this.getSubTransactionSize(); ++i) {
                result.subTransactions.add(this.getSubTransaction(i));
            }
            AbstractTransaction.setId(result);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public Account getAccount() {
        return this.account;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescription(boolean mergeComment) {
        if (!mergeComment || this.getComment() == null) {
            return this.getDescription();
        }
        return this.getDescription() + " (" + this.getComment() + ")";
    }

    public String getComment() {
        return this.comment;
    }

    public double getAmount() {
        return this.amount;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getSubTransactionSize() {
        return this.subTransactions.size();
    }

    public SubTransaction getSubTransaction(int index) {
        return this.subTransactions.get(index);
    }

    public SubTransaction[] getSubTransactions() {
        return this.subTransactions.toArray(new SubTransaction[this.subTransactions.size()]);
    }

    public long getId() {
        return this.id;
    }

    public double getComplement() {
        double result = this.getAmount();
        for (int i = 0; i < this.getSubTransactionSize(); ++i) {
            result -= this.getSubTransaction(i).getAmount();
        }
        if (GlobalData.AMOUNT_COMPARATOR.compare(result, 0.0) == 0) {
            result = 0.0;
        }
        return result;
    }

    public boolean hasCategory(Category category) {
        if (this.getCategory().equals(category)) {
            return true;
        }
        for (int j = 0; j < this.getSubTransactionSize(); ++j) {
            if (!this.getSubTransaction(j).getCategory().equals(category)) continue;
            return true;
        }
        return false;
    }

    List<SubTransaction> changeSubTransactions(Category oldCategory, Category newCategory) {
        ArrayList<SubTransaction> subTransactions = new ArrayList<SubTransaction>(this.getSubTransactionSize());
        for (int i = 0; i < this.getSubTransactionSize(); ++i) {
            SubTransaction sub = this.getSubTransaction(i);
            subTransactions.add(sub.getCategory().equals(oldCategory) ? new SubTransaction(sub.getAmount(), sub.getDescription(), newCategory) : sub);
        }
        return subTransactions;
    }
}

