/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.HashMap;
import java.util.Map;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;

public abstract class AbstractTransactionWizard<T> {
    private static final int MILLIS_PER_DAY = 86400000;
    protected GlobalData data;
    protected T value;
    protected boolean inited;

    protected AbstractTransactionWizard(GlobalData data) {
        this.data = data;
        this.value = null;
        this.inited = false;
    }

    protected abstract T getValue(Transaction var1);

    protected abstract boolean isValid(Transaction var1);

    protected double getRanking(Transaction transaction) {
        return AbstractTransactionWizard.getRankingBasedOnDate(System.currentTimeMillis(), transaction);
    }

    public static double getRankingBasedOnDate(long now, Transaction transaction) {
        long time = Math.abs(transaction.getDate().getTime() - now) / 86400000L;
        return 2.0 / Math.sqrt((double)time + 4.0);
    }

    public static <V> V getHeaviest(Map<V, Double> map) {
        V ct = null;
        double max = 0.0;
        for (Map.Entry<V, Double> next : map.entrySet()) {
            if (!(next.getValue() > max)) continue;
            ct = next.getKey();
            max = next.getValue();
        }
        return ct;
    }

    public T get() {
        if (!this.inited) {
            HashMap<T, Double> toProbability = new HashMap<T, Double>();
            for (int i = 0; i < this.data.getTransactionsNumber(); ++i) {
                T transactionValue;
                Transaction transaction = this.data.getTransaction(i);
                if (!this.isValid(transaction) || (transactionValue = this.getValue(transaction)) == null) continue;
                Double weight = (Double)toProbability.get(transactionValue);
                double transactionWeight = this.getRanking(transaction);
                toProbability.put(transactionValue, transactionWeight + (weight == null ? 0.0 : weight));
            }
            this.value = AbstractTransactionWizard.getHeaviest(toProbability);
        }
        return this.value;
    }
}

