/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.Date;
import net.yapbam.data.Account;
import net.yapbam.data.AlertThreshold;

public class Alert {
    private Date date;
    private Account account;
    private Kind kind;
    private double balance;
    private double threshold;

    Alert(Date date, Account account, double balance) {
        this.date = date;
        this.account = account;
        this.balance = balance;
        AlertThreshold t = this.account.getAlertThreshold();
        if (t.getTrigger(balance) > 0) {
            this.kind = Kind.IS_MORE;
            this.threshold = t.getMoreThreshold();
        } else {
            this.kind = Kind.IS_LESS;
            this.threshold = t.getLessThreshold();
        }
    }

    public Date getDate() {
        return this.date;
    }

    public Account getAccount() {
        return this.account;
    }

    public Kind getKind() {
        return this.kind;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public double getBalance() {
        return this.balance;
    }

    public static enum Kind {
        IS_LESS,
        IS_MORE;

    }
}

