/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import net.yapbam.data.FilteredData;
import net.yapbam.data.PeriodicalTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.data.event.AccountAddedEvent;
import net.yapbam.data.event.CategoryAddedEvent;
import net.yapbam.data.event.CheckbookAddedEvent;
import net.yapbam.data.event.CheckbookPropertyChangedEvent;
import net.yapbam.data.event.CheckbookRemovedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.IsArchivedChangedEvent;
import net.yapbam.data.event.IsLockedChangedEvent;
import net.yapbam.data.event.ModeAddedEvent;
import net.yapbam.data.event.NeedToBeSavedChangedEvent;
import net.yapbam.data.event.PasswordChangedEvent;
import net.yapbam.data.event.URIChangedEvent;

public class PeriodicalTransactionSimulationData
extends Observable {
    private FilteredData data;
    private Date endDate;
    private boolean ignoreFilter;
    private boolean needRefresh;
    private double totalExpenses;
    private double totalReceipts;
    private int nbTransactions;

    public PeriodicalTransactionSimulationData(FilteredData data) {
        this.data = data;
        this.ignoreFilter = true;
        this.setEndDate(Unit.YEAR, 1);
        data.getGlobalData().addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (PeriodicalTransactionSimulationData.this.hasImpact(event)) {
                    PeriodicalTransactionSimulationData.this.invalidate();
                }
            }
        });
        data.getFilter().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (!PeriodicalTransactionSimulationData.this.ignoreFilter) {
                    PeriodicalTransactionSimulationData.this.invalidate();
                }
            }
        });
    }

    private boolean hasImpact(DataEvent event) {
        return !(event instanceof AccountAddedEvent) && !(event instanceof CategoryAddedEvent) && !(event instanceof CheckbookAddedEvent) && !(event instanceof CheckbookPropertyChangedEvent) && !(event instanceof CheckbookRemovedEvent) && !(event instanceof IsArchivedChangedEvent) && !(event instanceof IsLockedChangedEvent) && !(event instanceof ModeAddedEvent) && !(event instanceof NeedToBeSavedChangedEvent) && !(event instanceof PasswordChangedEvent) && !(event instanceof URIChangedEvent);
    }

    public void setEndDate(Unit unit, int amount) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        ((Calendar)cal).add(unit.getField(), amount);
        Date date = cal.getTime();
        if (!date.equals(this.endDate)) {
            this.endDate = date;
            this.needRefresh = true;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void setIgnoreFilter(boolean ignore) {
        if (ignore != this.ignoreFilter) {
            this.ignoreFilter = ignore;
            this.needRefresh = true;
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void refresh() {
        if (this.needRefresh) {
            this.nbTransactions = 0;
            this.totalReceipts = 0.0;
            this.totalExpenses = -0.0;
            for (int i = 0; i < this.data.getGlobalData().getPeriodicalTransactionsNumber(); ++i) {
                PeriodicalTransaction pt = this.data.getGlobalData().getPeriodicalTransaction(i);
                if (!this.ignoreFilter && !this.data.getFilter().isOk(pt)) continue;
                List<Transaction> generated = pt.generate(this.endDate, null);
                this.nbTransactions += generated.size();
                double total = 0.0;
                for (Transaction transaction : generated) {
                    total += transaction.getAmount();
                }
                if (total < 0.0) {
                    this.totalExpenses += total;
                    continue;
                }
                this.totalReceipts += total;
            }
        }
    }

    public double getTotalExpenses() {
        this.refresh();
        return this.totalExpenses;
    }

    public double getTotalReceips() {
        this.refresh();
        return this.totalReceipts;
    }

    public int getNbTransactions() {
        this.refresh();
        return this.nbTransactions;
    }

    private void invalidate() {
        this.needRefresh = true;
        this.setChanged();
        this.notifyObservers();
    }

    public static enum Unit {
        MONTH(2),
        YEAR(1);

        private int field;

        private Unit(int field) {
            this.field = field;
        }

        public int getField() {
            return this.field;
        }
    }
}

