/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.Comparator;
import net.yapbam.data.Transaction;
import net.yapbam.util.NullUtils;

abstract class TransactionComparator
implements Comparator<Transaction> {
    static final TransactionComparator INSTANCE = new TransactionComparator(){

        @Override
        public int compare(Transaction o1, Transaction o2) {
            int result = o1.getDateAsInteger() - o2.getDateAsInteger();
            if (result == 0) {
                result = o1.getAccount().getName().compareToIgnoreCase(o2.getAccount().getName());
            }
            if (result == 0) {
                result = NullUtils.compareTo((Comparable)((Object)o1.getStatement()), (Comparable)((Object)o2.getStatement()), true);
            }
            if (result == 0) {
                result = (int)(Math.signum(o1.getAmount()) - Math.signum(o2.getAmount()));
            }
            if (result == 0) {
                result = Long.signum(o1.getId() - o2.getId());
            }
            if (result == 0) {
                result = o1.getValueDateAsInteger() - o2.getValueDateAsInteger();
            }
            if (result == 0) {
                result = TransactionComparator.partialCompare(o1, o2);
            }
            return result;
        }
    };
    static final TransactionComparator VALUE_DATE_COMPARATOR = new TransactionComparator(){

        @Override
        public int compare(Transaction o1, Transaction o2) {
            int result = o1.getValueDateAsInteger() - o2.getValueDateAsInteger();
            if (result == 0) {
                result = (int)(Math.signum(o2.getAmount()) - Math.signum(o1.getAmount()));
            }
            if (result == 0) {
                result = o1.getDateAsInteger() - o2.getDateAsInteger();
            }
            if (result == 0) {
                result = NullUtils.compareTo((Comparable)((Object)o1.getStatement()), (Comparable)((Object)o2.getStatement()), true);
            }
            if (result == 0) {
                result = Long.signum(o1.getId() - o2.getId());
            }
            if (result == 0) {
                result = TransactionComparator.partialCompare(o1, o2);
            }
            if (result == 0) {
                result = o1.getAccount().getName().compareToIgnoreCase(o2.getAccount().getName());
            }
            return result;
        }
    };

    private TransactionComparator() {
    }

    private static int partialCompare(Transaction o1, Transaction o2) {
        int result = o1.getMode().getName().compareToIgnoreCase(o2.getMode().getName());
        if (result == 0) {
            result = NullUtils.compareTo((Comparable)((Object)o1.getNumber()), (Comparable)((Object)o2.getNumber()), true);
        }
        if (result == 0) {
            result = o1.getCategory().getName().compareToIgnoreCase(o2.getCategory().getName());
        }
        if (result == 0) {
            result = o1.getDescription().compareToIgnoreCase(o2.getDescription());
        }
        if (result == 0) {
            result = (int)Math.signum(o1.getAmount() - o2.getAmount());
        }
        return result;
    }
}

