/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import org.slf4j.LoggerFactory;

public abstract class DefaultListenable {
    private static final boolean TRACE_LISTENERS = Boolean.getBoolean("traceEventListeners");
    private static final boolean TRACE_EVENTS = Boolean.getBoolean("traceEvents");
    private static final boolean TRACE_ALL = Boolean.getBoolean("traceAll");
    private static int indent = 0;
    private Collection<DataListener> listeners = new ArrayList<DataListener>();
    private boolean eventsDisabled;

    protected DefaultListenable() {
        this.setEventsEnabled(true);
    }

    protected void setEventsEnabled(boolean enabled) {
        this.eventsDisabled = !enabled;
    }

    protected boolean isEventsEnabled() {
        return !this.eventsDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(DataEvent event) {
        if (this.eventsDisabled) {
            return;
        }
        if (TRACE_EVENTS && !TRACE_ALL) {
            this.trace("Event " + event + " occurs on " + this);
        }
        Iterator<DataListener> iterator = this.listeners.iterator();
        if (TRACE_ALL && this.listeners.isEmpty()) {
            this.trace("Event " + event + " occurs on " + this + " but nobody is listening");
        }
        while (iterator.hasNext()) {
            DataListener listener = iterator.next();
            if (TRACE_ALL) {
                this.trace("Send event " + event + " on " + this + " to " + listener);
            }
            indent += 2;
            try {
                listener.processEvent(event);
            }
            finally {
                indent -= 2;
            }
        }
    }

    private void trace(String message) {
        StringBuilder builder = new StringBuilder(indent + message.length());
        for (int i = 0; i < indent; ++i) {
            builder.append(' ');
        }
        builder.append(message);
        LoggerFactory.getLogger(this.getClass()).debug(message);
    }

    public void addListener(DataListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<DataListener>();
        }
        if (TRACE_ALL || TRACE_LISTENERS) {
            LoggerFactory.getLogger(this.getClass()).debug("Add listener {} on {}", (Object)listener, (Object)this);
        }
        this.listeners.add(listener);
    }

    public void clearListeners() {
        if (TRACE_ALL || TRACE_LISTENERS) {
            LoggerFactory.getLogger(this.getClass()).debug("All listeners are cleared on " + this);
        }
        this.listeners.clear();
    }

    public int getNumberOfListeners() {
        return this.listeners.size();
    }
}

