/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data.xml;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.yapbam.data.Account;
import net.yapbam.data.Category;
import net.yapbam.data.Filter;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.xml.DelegateHandler;
import net.yapbam.data.xml.XMLSerializer;
import net.yapbam.util.ArrayUtils;
import net.yapbam.util.DateUtils;
import net.yapbam.util.TextMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FilterHandler
extends DelegateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterHandler.class);
    private GlobalData data;
    private Filter filter;
    private TextMatcher descriptionMatcher;
    private TextMatcher commentMatcher;
    private TextMatcher numberMatcher;
    private TextMatcher statementMatcher;
    private int property;

    public FilterHandler(GlobalData data) {
        this.data = data;
    }

    @Override
    protected String getRootTag() {
        return "FILTER";
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("FILTER")) {
            String modesString;
            String categoriesString;
            this.filter = new Filter();
            this.filter.setName(attributes.getValue("id"));
            Date dateFrom = DateUtils.integerToDate(XMLSerializer.toDate(attributes.getValue("dateFrom")));
            Date dateTo = DateUtils.integerToDate(XMLSerializer.toDate(attributes.getValue("dateTo")));
            this.filter.setDateFilter(dateFrom, dateTo);
            Date valueDateFrom = DateUtils.integerToDate(XMLSerializer.toDate(attributes.getValue("valueDateFrom")));
            Date valueDateTo = DateUtils.integerToDate(XMLSerializer.toDate(attributes.getValue("valueDateTo")));
            this.filter.setValueDateFilter(valueDateFrom, valueDateTo);
            String amountFrom = attributes.getValue("amountFrom");
            String amountTo = attributes.getValue("amountTo");
            String filterString = attributes.getValue("filter");
            this.property = filterString == null ? 15 : Integer.parseInt(filterString);
            this.filter.setAmountFilter(this.property, amountFrom == null ? 0.0 : Double.parseDouble(amountFrom), amountTo == null ? Double.POSITIVE_INFINITY : Double.parseDouble(amountTo));
            String accountsString = attributes.getValue("account");
            if (accountsString != null) {
                String[] names = ArrayUtils.parseStringArray(accountsString);
                ArrayList<Account> accounts = new ArrayList<Account>();
                for (String name : names) {
                    Account account = this.data.getAccount(name);
                    if (account == null) continue;
                    accounts.add(account);
                }
                if (!accounts.isEmpty()) {
                    this.filter.setValidAccounts(accounts);
                }
            }
            if ((categoriesString = attributes.getValue("category")) != null) {
                String[] names = ArrayUtils.parseStringArray(categoriesString);
                ArrayList<Category> categories = new ArrayList<Category>();
                for (String name : names) {
                    Category category;
                    Category category2 = category = (name = name.trim()).isEmpty() ? Category.UNDEFINED : this.data.getCategory(name);
                    if (category == null) continue;
                    categories.add(category);
                }
                if (!categories.isEmpty() && categories.size() != this.data.getCategoriesNumber()) {
                    this.filter.setValidCategories(categories);
                }
            }
            if ((modesString = attributes.getValue("mode")) != null) {
                String[] names = ArrayUtils.parseStringArray(modesString);
                Set<String> dataNames = this.getAllValidAccountsModeNames();
                ArrayList<String> modes = new ArrayList<String>();
                for (String name : names) {
                    if (!dataNames.contains(name = name.trim())) continue;
                    modes.add(name);
                }
                if (!modes.isEmpty() && modes.size() != dataNames.size()) {
                    this.filter.setValidModes(modes);
                }
            }
        } else if (qName.equals("TEXT_MATCHER")) {
            String id = attributes.getValue("id");
            String kindString = attributes.getValue("kind");
            TextMatcher.Kind kind = null;
            if (kindString.equals("contains")) {
                kind = TextMatcher.Kind.CONTAINS;
            } else if (kindString.equals("equals")) {
                kind = TextMatcher.Kind.EQUALS;
            } else if (kindString.equals("regular")) {
                kind = TextMatcher.Kind.REGULAR;
            }
            String filter = XMLSerializer.decode(attributes.getValue("filter"));
            String bString = attributes.getValue("caseSensitive");
            boolean caseSensitive = bString == null ? false : Boolean.parseBoolean(bString);
            bString = attributes.getValue("diacriticalSensitive");
            boolean diacriticalSensitive = bString == null ? false : Boolean.parseBoolean(bString);
            TextMatcher textMatcher = new TextMatcher(kind, filter, caseSensitive, diacriticalSensitive);
            if (id.equals("description")) {
                this.descriptionMatcher = textMatcher;
            } else if (id.equals("comment")) {
                this.commentMatcher = textMatcher;
            } else if (id.equals("number")) {
                this.numberMatcher = textMatcher;
            } else if (id.equals("statement")) {
                this.statementMatcher = textMatcher;
            }
        } else {
            LOGGER.warn("Unknown tag {}", (Object)qName);
        }
    }

    private Set<String> getAllValidAccountsModeNames() {
        HashSet<String> result = new HashSet<String>();
        List<Account> accounts = this.filter.getValidAccounts();
        if (accounts == null) {
            accounts = new ArrayList<Account>(this.data.getAccountsNumber());
            for (int i = 0; i < this.data.getAccountsNumber(); ++i) {
                accounts.add(this.data.getAccount(i));
            }
        }
        for (Account account : accounts) {
            for (int i = 0; i < account.getModesNumber(); ++i) {
                Mode mode = account.getMode(i);
                result.add(mode.equals(Mode.UNDEFINED) ? "" : mode.getName());
            }
        }
        return result;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("FILTER")) {
            this.filter.setDescriptionMatcher(this.descriptionMatcher);
            this.filter.setCommentMatcher(this.commentMatcher);
            this.filter.setNumberMatcher(this.numberMatcher);
            this.filter.setStatementFilter(this.property, this.statementMatcher);
        } else if (qName.equals("TEXT_MATCHER")) {
            // empty if block
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String str = new String(ch, start, length);
        if ((str = str.trim()).length() != 0) {
            LOGGER.warn("Strange, characters is called on: {}", (Object)str);
        }
    }

    public Filter getFilter() {
        return this.filter;
    }
}

