/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data.xml.task;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.security.MessageDigest;
import java.util.concurrent.Callable;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import net.yapbam.data.xml.task.EncrypterTask;
import net.yapbam.util.StreamUtils;

public class DecrypterTask
implements Callable<Void> {
    private InputStream in;
    private OutputStream out;
    private boolean compatibilityMode;
    private String password;

    public DecrypterTask(InputStream in, OutputStream out, String password, boolean compatibilityMode) {
        this.in = in;
        this.out = out;
        this.password = password;
        this.compatibilityMode = compatibilityMode;
    }

    public static void verifyPassword(InputStream stream, String password) throws IOException, AccessControlException {
        int nb;
        byte[] digest = EncrypterTask.getDigest(password);
        byte[] fileDigest = new byte[digest.length];
        for (int missing = fileDigest.length; missing > 0; missing -= nb) {
            nb = stream.read(fileDigest, fileDigest.length - missing, missing);
            if (nb != -1) continue;
            throw new IOException("end of stream reached before end of password digest");
        }
        if (!MessageDigest.isEqual(digest, fileDigest)) {
            throw new AccessControlException("invalid password");
        }
    }

    @Override
    public Void call() throws Exception {
        try {
            DecrypterTask.verifyPassword(this.in, this.password);
            Cipher cipher = EncrypterTask.getCipher(2, this.password, this.compatibilityMode);
            this.out = new CipherOutputStream(this.out, cipher);
            StreamUtils.copy(this.in, this.out, new byte[10240]);
            Void void_ = null;
            return void_;
        }
        finally {
            this.in.close();
            this.out.close();
        }
    }
}

