/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.date.helpers;

import java.util.Date;
import java.util.GregorianCalendar;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DayDateStepper
extends DateStepper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DayDateStepper.class);
    private static final boolean DEBUG = false;
    private int nbDays;
    private int lastDate;

    public DayDateStepper(int nbDays, Date lastDate) {
        this.nbDays = nbDays;
        this.lastDate = lastDate == null ? Integer.MAX_VALUE : DateUtils.dateToInteger(lastDate);
    }

    @Override
    public Date getNextStep(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.add(5, this.nbDays);
        Date result = gc.getTime();
        if (DateUtils.dateToInteger(result) > this.lastDate) {
            result = null;
        }
        return result;
    }

    public int getStep() {
        return this.nbDays;
    }

    @Override
    public Date getLastDate() {
        return this.lastDate == Integer.MAX_VALUE ? null : DateUtils.integerToDate(this.lastDate);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DayDateStepper)) {
            return false;
        }
        return this.getStep() == ((DayDateStepper)obj).getStep() && this.lastDate == ((DayDateStepper)obj).lastDate;
    }

    public int hashCode() {
        return this.getStep() + this.lastDate;
    }
}

