/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui;

import com.fathzer.soft.ajlib.utilities.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.ResourceBundle;
import net.yapbam.util.CheckSum;
import net.yapbam.util.Portable;

class FolderCleaner {
    private FolderCleaner() {
    }

    static void buildProperties(String[] paths, File[] folders) throws IOException {
        for (String filePath : paths) {
            String[] checksums = CheckSum.getCheckSums(folders, filePath);
            if (checksums.length <= 0) continue;
            System.out.print(URLEncoder.encode(filePath) + "=");
            for (int i = 0; i < checksums.length; ++i) {
                if (i != 0) {
                    System.out.print(',');
                }
                System.out.print(checksums[i]);
            }
            System.out.println();
        }
    }

    private static void clean(File installationFolder) {
        try {
            ArrayList<CleaningJob> jobs = new ArrayList<CleaningJob>();
            ResourceBundle checksumsMap = ResourceBundle.getBundle(FolderCleaner.class.getPackage().getName() + ".obsoleteFilesChecksums");
            for (String path : checksumsMap.keySet()) {
                jobs.add(new CleaningJob(new File(installationFolder, URLDecoder.decode(path)), checksumsMap.getString(path).split(","), null));
            }
            jobs.add(new CleaningJob(new File(installationFolder, ".yapbam"), new String[0], new File(Portable.getDataDirectory(), ".yapbam")));
            jobs.add(new CleaningJob(new File(installationFolder, ".yapbampref"), new String[0], new File(Portable.getDataDirectory(), ".yapbampref")));
            for (CleaningJob job : jobs) {
                job.clean();
            }
            new File(installationFolder, "help/fr").delete();
            new File(installationFolder, "help").delete();
            new File(installationFolder, "Other/samples").delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void clean() {
        if (Portable.isPortable()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    FolderCleaner.clean(Portable.getApplicationDirectory());
                }
            }).start();
        }
    }

    static class CleaningJob {
        File source;
        String[] checkSums;
        File destination;

        CleaningJob(File source, String[] checkSums, File destination) {
            this.source = source;
            this.checkSums = checkSums;
            this.destination = destination;
        }

        void clean() {
            try {
                if (this.source.exists() && this.source.canWrite() && this.isValidCheckSum()) {
                    if (this.destination == null) {
                        this.source.delete();
                    } else {
                        FileUtils.move(this.source, this.destination);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        private boolean isValidCheckSum() throws IOException {
            if (this.checkSums.length == 0) {
                return true;
            }
            String checkSum = CheckSum.toString(CheckSum.getChecksum(this.source));
            for (String validCheckSum : this.checkSums) {
                if (!validCheckSum.equals(checkSum)) continue;
                return true;
            }
            return false;
        }
    }
}

