/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import net.yapbam.data.FilteredData;
import net.yapbam.gui.AbstractPlugIn;

public class PlugInContainer {
    private Class<? extends AbstractPlugIn> plugin;
    private boolean isActivated;
    private Throwable e;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlugInContainer(File file) {
        try {
            JarFile jar = new JarFile(file);
            try {
                Attributes attributes = jar.getManifest().getMainAttributes();
                String className = attributes.getValue("Plugin-Class");
                if (className != null) {
                    URLClassLoader classLoader = new URLClassLoader(new URL[]{file.toURI().toURL()});
                    try {
                        this.plugin = classLoader.loadClass(className);
                    }
                    finally {
                        try {
                            classLoader.getClass().getMethod("close", new Class[0]).invoke((Object)classLoader, new Object[0]);
                        }
                        catch (Exception exception) {}
                    }
                }
                this.isActivated = true;
            }
            finally {
                jar.close();
            }
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    PlugInContainer(Class<? extends AbstractPlugIn> plugin) {
        this.plugin = plugin;
        this.isActivated = true;
    }

    public AbstractPlugIn build(FilteredData filteredData, Object restartData) {
        if (this.plugin == null) {
            return null;
        }
        try {
            Constructor<? extends AbstractPlugIn> constructor = this.plugin.getConstructor(FilteredData.class, Object.class);
            return constructor.newInstance(filteredData, restartData);
        }
        catch (Throwable e) {
            this.e = e;
            this.isActivated = false;
            return null;
        }
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public String toString() {
        return this.plugin.getCanonicalName();
    }

    public Throwable getInstanciationException() {
        return this.e;
    }
}

