/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui;

import com.fathzer.soft.ajlib.swing.FontUtils;
import com.fathzer.soft.ajlib.utilities.FileUtils;
import com.fathzer.soft.ajlib.utilities.StringUtils;
import java.awt.Font;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.PlugInContainer;
import net.yapbam.gui.accountsummary.AccountsSummaryPlugin;
import net.yapbam.gui.administration.AdministrationPlugIn;
import net.yapbam.gui.archive.ArchivePlugin;
import net.yapbam.gui.budget.BudgetPlugin;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryPlugIn;
import net.yapbam.gui.preferences.EditingSettings;
import net.yapbam.gui.preferences.EditionWizardSettings;
import net.yapbam.gui.preferences.StartStateSettings;
import net.yapbam.gui.recent.RecentFilesPlugin;
import net.yapbam.gui.statementview.StatementViewPlugin;
import net.yapbam.gui.statistics.StatisticsPlugin;
import net.yapbam.gui.tools.ToolsPlugIn;
import net.yapbam.gui.transactiontable.TransactionsPlugIn;
import net.yapbam.gui.transfer.TransferPlugin;
import net.yapbam.gui.util.LookAndFeelUtils;
import net.yapbam.gui.welcome.WelcomePlugin;
import net.yapbam.util.Crypto;
import net.yapbam.util.HttpsPatcherPlugin;
import net.yapbam.util.Portable;
import net.yapbam.util.PreferencesUtils;

public class Preferences {
    private static final String FONT_NAME = "Font.name";
    private static final String FONT_SIZE_RATIO = "Font.sizeRatio";
    private static final String LANGUAGE = "lang";
    private static final String COUNTRY = "country";
    private static final String LANGUAGE_DEFAULT_VALUE = "default";
    private static final String COUNTRY_DEFAULT_VALUE = "default";
    private static final String LOOK_AND_FEEL = "look";
    private static final String LOOK_AND_FEEL_JAVA_VALUE = "java";
    private static final String LOOK_AND_FEEL_CUSTOM_VALUE = "custom";
    private static final String PROXY = "proxy";
    private static final String PROXY_AUTHENTICATION = "proxy_pass";
    private static final String AUTO_UPDATE_PERIOD = "auto_update_period";
    private static final String AUTO_UPDATE_INSTALL = "auto_update_install";
    private static final String EXPERT_MODE = "expert_mode";
    private static final String WELCOME_DIALOG_ALLOWED = "welcome_dialog_enabled";
    private static final String CRASH_REPORT_ACTION = "crash_report_action";
    private static final String KEY = "6a2a46e94506ebc3957df475e1da7f78";
    private static final String PREF_PREFIX = "TransactionEditing.";
    private static final String EDITION_WIZARD_MODE = "fillAmount";
    private static final String EDITION_WIZARD_SOURCE = "fillAmountWith";
    private static final String DELETE_ALERT = "alertOnDelete";
    private static final String MODIFY_CHECKED_ALERT = "alertOnModifyChecked";
    private static final String AUTO_FILL_STATEMENT = "autoFillStatement";
    private static final String SET_DUPLICATE_TRANSACTION_DATE_TO_CURRENT = "setDuplicateTransactionDateToCurrent";
    private static final String DATE_BASED_AUTO_STATEMENT = "dateBasedAutoStatement";
    private static final String AUTO_STATEMENT_FORMAT = "statementDateFormat";
    private static final String PREF_START_PREFIX = "StartState.remember.";
    private static final String FILE = "file";
    private static final String FILTER = "filter";
    private static final String TABS_ORDER = "tabsOrder";
    private static final String ROW_SORTER_KEYS = "rowSorterKeys";
    private static final String COLUMNS_WIDTH = "columnsWidth";
    private static final String COLUMNS_ORDER = "columnsOrder";
    private static final String HIDDEN_COLUMNS = "hiddenColumns";
    public static final Preferences INSTANCE = new Preferences();
    private Properties properties = new Properties();
    private boolean firstRun;
    private boolean translatorMode;
    private EditingSettings editingOptions;
    private StartStateSettings startStateOptions;

    private Preferences() {
        try {
            this.load();
            if (!this.firstRun) {
                this.setAuthentication();
            } else {
                this.setToDefault();
                this.save();
            }
        }
        catch (Throwable e) {
            ErrorManager.INSTANCE.log(null, e);
        }
    }

    private static File getFile() {
        return new File(Portable.getDataDirectory(), ".yapbampref");
    }

    private void setToDefault() {
        this.properties.clear();
        this.put(LANGUAGE, "default");
        this.put(COUNTRY, "default");
    }

    private void put(String key, String value) {
        PreferencesUtils.verifyPreferencesCompliance(key, value);
        this.properties.put(key, value);
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    private void load() throws IOException {
        if (Portable.isPortable()) {
            boolean bl = this.firstRun = !Preferences.getFile().exists();
            if (!this.firstRun) {
                FileInputStream inStream = new FileInputStream(Preferences.getFile());
                try {
                    this.properties.load(inStream);
                }
                finally {
                    inStream.close();
                }
            }
        } else {
            java.util.prefs.Preferences prefs = Preferences.getJavaPref();
            this.firstRun = PreferencesUtils.isEmpty(prefs);
            PreferencesUtils.fromPreferences(prefs, this.properties);
        }
    }

    public void save() throws IOException {
        if (Portable.isPortable()) {
            File file = Preferences.getFile();
            file.getParentFile().mkdirs();
            FileOutputStream out = FileUtils.getHiddenCompliantStream(file);
            try {
                this.properties.store(out, "Yapbam preferences");
            }
            finally {
                out.close();
            }
        } else {
            PreferencesUtils.toPreferences(Preferences.getJavaPref(), this.properties, true);
        }
    }

    private static java.util.prefs.Preferences getJavaPref() {
        return java.util.prefs.Preferences.userRoot().node("net.yapbam.prefs");
    }

    public Locale getLocale() {
        String country;
        String lang = this.properties.getProperty(LANGUAGE);
        if ("default".equalsIgnoreCase(lang)) {
            lang = LocalizationData.SYS_LOCALE.getLanguage();
        }
        if ("default".equalsIgnoreCase(country = this.properties.getProperty(COUNTRY))) {
            country = LocalizationData.SYS_LOCALE.getCountry();
        }
        return new Locale(lang, country);
    }

    static Locale safeGetLocale() {
        return INSTANCE != null ? INSTANCE.getLocale() : LocalizationData.SYS_LOCALE;
    }

    public boolean isDefaultCountry() {
        return "default".equalsIgnoreCase((String)this.properties.get(COUNTRY));
    }

    public boolean isDefaultLanguage() {
        return "default".equalsIgnoreCase((String)this.properties.get(LANGUAGE));
    }

    public void setLocale(Locale locale, boolean defaultCountry, boolean defaultLanguage) {
        this.put(LANGUAGE, defaultLanguage ? "default" : locale.getLanguage());
        this.put(COUNTRY, defaultCountry ? "default" : locale.getCountry());
    }

    public String getLookAndFeel() {
        String value = this.properties.getProperty(LOOK_AND_FEEL);
        String string = value = LookAndFeelUtils.isValid(value) ? value : null;
        if (LOOK_AND_FEEL_JAVA_VALUE.equalsIgnoreCase(value)) {
            value = this.getLookAndFeelName(UIManager.getCrossPlatformLookAndFeelClassName());
        } else if (LOOK_AND_FEEL_CUSTOM_VALUE.equalsIgnoreCase(value)) {
            value = this.getLookAndFeelName(UIManager.getSystemLookAndFeelClassName());
        }
        if (value == null) {
            value = "Nimbus";
        }
        return value;
    }

    private String getLookAndFeelName(String className) {
        UIManager.LookAndFeelInfo[] installedLookAndFeels;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : installedLookAndFeels = UIManager.getInstalledLookAndFeels()) {
            if (!lookAndFeelInfo.getClassName().equals(className)) continue;
            return lookAndFeelInfo.getName();
        }
        return null;
    }

    public void setLookAndFeel(String lookAndFeelName) {
        this.put(LOOK_AND_FEEL, lookAndFeelName);
    }

    public String getHttpProxyHost() {
        String property = this.properties.getProperty(PROXY);
        if (property == null || property.length() == 0) {
            return null;
        }
        int index = property.lastIndexOf(58);
        if (index < 0) {
            return property;
        }
        return property.substring(0, index);
    }

    public int getHttpProxyPort() {
        String property = this.properties.getProperty(PROXY);
        if (property == null) {
            return -1;
        }
        String[] tokens = StringUtils.split(property, ':');
        try {
            return Integer.parseInt(tokens[tokens.length - 1]);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public Proxy getHttpProxy() throws UnknownHostException {
        String property = this.getHttpProxyHost();
        if (property == null) {
            return Proxy.NO_PROXY;
        }
        InetAddress host = InetAddress.getByName(property);
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, INSTANCE.getHttpProxyPort()));
    }

    public String getHttpProxyUser() {
        String property = this.properties.getProperty(PROXY_AUTHENTICATION);
        if (property == null) {
            return null;
        }
        return new StringTokenizer(Crypto.decrypt(KEY, property), ":").nextToken();
    }

    public String getHttpProxyPassword() {
        String property = this.properties.getProperty(PROXY_AUTHENTICATION);
        if (property == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(Crypto.decrypt(KEY, property), ":");
        tokens.nextToken();
        return tokens.nextToken();
    }

    public void setHttpProxy(String proxyHost, Integer proxyPort, String user, String password) {
        if (proxyHost == null) {
            this.properties.remove(PROXY);
            user = null;
        } else {
            this.put(PROXY, proxyHost + ":" + proxyPort);
        }
        if (user == null) {
            Authenticator.setDefault(null);
            this.properties.remove(PROXY_AUTHENTICATION);
        } else {
            this.put(PROXY_AUTHENTICATION, Crypto.encrypt(KEY, user + ":" + password));
            this.setAuthentication();
        }
    }

    private void setAuthentication() {
        String property = this.properties.getProperty(PROXY_AUTHENTICATION);
        if (property == null) {
            Authenticator.setDefault(null);
        } else {
            StringTokenizer tokens = new StringTokenizer(Crypto.decrypt(KEY, property), ":");
            final String user = tokens.nextToken();
            final String pwd = tokens.nextToken();
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, pwd.toCharArray());
                }
            });
        }
    }

    public boolean isWelcomeAllowed() {
        String property = this.properties.getProperty(WELCOME_DIALOG_ALLOWED);
        if (property == null) {
            return true;
        }
        return Boolean.parseBoolean(property);
    }

    public void setWelcomeAllowed(boolean allowed) {
        this.properties.setProperty(WELCOME_DIALOG_ALLOWED, Boolean.toString(allowed));
    }

    public int getAutoUpdatePeriod() {
        try {
            return Integer.parseInt(this.properties.getProperty(AUTO_UPDATE_PERIOD));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public boolean getAutoUpdateInstall() {
        try {
            return Boolean.parseBoolean(this.properties.getProperty(AUTO_UPDATE_INSTALL));
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setAutoUpdate(int days, boolean autoInstall) {
        this.properties.setProperty(AUTO_UPDATE_PERIOD, Integer.toString(days));
        this.properties.setProperty(AUTO_UPDATE_INSTALL, Boolean.toString(autoInstall));
    }

    static PlugInContainer[] getPlugins() {
        String testedPlugin;
        final ArrayList<PlugInContainer> plugins = new ArrayList<PlugInContainer>();
        plugins.add(new PlugInContainer(WelcomePlugin.class));
        plugins.add(new PlugInContainer(TransactionsPlugIn.class));
        plugins.add(new PlugInContainer(BalanceHistoryPlugIn.class));
        plugins.add(new PlugInContainer(StatementViewPlugin.class));
        plugins.add(new PlugInContainer(StatisticsPlugin.class));
        plugins.add(new PlugInContainer(BudgetPlugin.class));
        plugins.add(new PlugInContainer(AccountsSummaryPlugin.class));
        plugins.add(new PlugInContainer(ToolsPlugIn.class));
        plugins.add(new PlugInContainer(AdministrationPlugIn.class));
        plugins.add(new PlugInContainer(TransferPlugin.class));
        plugins.add(new PlugInContainer(RecentFilesPlugin.class));
        plugins.add(new PlugInContainer(ArchivePlugin.class));
        plugins.add(new PlugInContainer(HttpsPatcherPlugin.class));
        File file = new File(Portable.getDataDirectory(), "plugins");
        if (file.exists() || !file.mkdirs()) {
            // empty if block
        }
        if (file.exists() && file.isDirectory()) {
            file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (!file.getName().endsWith(".jar")) {
                        return false;
                    }
                    plugins.add(new PlugInContainer(file));
                    return true;
                }
            });
        }
        if ((testedPlugin = System.getProperty("testedPlugin.className")) != null) {
            String[] testedPlugins;
            for (String className : testedPlugins = StringUtils.split(testedPlugin, ',')) {
                if (className.length() == 0) continue;
                try {
                    Class<?> pClass = Class.forName(className);
                    plugins.add(new PlugInContainer(pClass));
                }
                catch (Exception e) {
                    ErrorManager.INSTANCE.display(null, e, "Unable to load the plugin " + className);
                }
            }
        }
        return plugins.toArray(new PlugInContainer[plugins.size()]);
    }

    public boolean isExpertMode() {
        return this.getBoolean(EXPERT_MODE, false);
    }

    private boolean getBoolean(String key, boolean defaultValue) {
        try {
            String property = this.properties.getProperty(key);
            return property == null ? defaultValue : Boolean.parseBoolean(property);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private void setBoolean(String key, boolean value) {
        Preferences pref = INSTANCE;
        pref.setProperty(key, Boolean.toString(value));
    }

    public boolean isTranslatorMode() {
        return this.translatorMode;
    }

    public static boolean safeIsTranslatorMode() {
        return INSTANCE != null ? INSTANCE.isTranslatorMode() : false;
    }

    public void setTranslatorMode(boolean translatorMode) {
        this.translatorMode = translatorMode;
    }

    public void setProperty(String key, String value) {
        PreferencesUtils.verifyPreferencesCompliance(key, value);
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        String result = this.getProperty(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public int getCrashReportAction() {
        try {
            return Integer.parseInt(this.properties.getProperty(CRASH_REPORT_ACTION, "0"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    static int safeGetCrashReportAction() {
        return INSTANCE == null ? 0 : INSTANCE.getCrashReportAction();
    }

    public void setCrashReportAction(int action) {
        if (Math.abs(action) > 1) {
            throw new IllegalArgumentException();
        }
        this.properties.setProperty(CRASH_REPORT_ACTION, Integer.toString(action));
    }

    public void setEditingOptions(EditingSettings edit) {
        this.editingOptions = edit;
        this.setBoolean("TransactionEditing.alertOnDelete", edit.isAlertOnDelete());
        this.setBoolean("TransactionEditing.alertOnModifyChecked", edit.isAlertOnModifyChecked());
        this.setBoolean("TransactionEditing.setDuplicateTransactionDateToCurrent", edit.isDuplicateTransactionDateToCurrent());
        this.setBoolean("TransactionEditing.autoFillStatement", edit.isAutoFillStatement());
        this.setBoolean("TransactionEditing.dateBasedAutoStatement", edit.isDateBasedAutoStatement());
        this.properties.setProperty("TransactionEditing.statementDateFormat", edit.getStatementDateFormat().toPattern());
        this.properties.setProperty("TransactionEditing.fillAmount", edit.getEditionWizardSettings().getMode().name());
        this.properties.setProperty("TransactionEditing.fillAmountWith", edit.getEditionWizardSettings().getSource().name());
    }

    public EditingSettings getEditionSettings() {
        if (this.editingOptions == null) {
            String defaultPattern = "yyyyMM";
            String pattern = this.properties.getProperty("TransactionEditing.statementDateFormat", defaultPattern);
            SimpleDateFormat format = new SimpleDateFormat(defaultPattern);
            try {
                format = new SimpleDateFormat(pattern, this.getLocale());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            EditionWizardSettings edwSettings = new EditionWizardSettings(EditionWizardSettings.Mode.valueOf(this.getProperty("TransactionEditing.fillAmount", EditionWizardSettings.Mode.NEVER.name())), EditionWizardSettings.Source.valueOf(this.getProperty("TransactionEditing.fillAmountWith", EditionWizardSettings.Source.MOST_PROBABLE.name())));
            this.editingOptions = new EditingSettings(this.getBoolean("TransactionEditing.alertOnDelete", true), this.getBoolean("TransactionEditing.alertOnModifyChecked", true), this.getBoolean("TransactionEditing.setDuplicateTransactionDateToCurrent", true), this.getBoolean("TransactionEditing.autoFillStatement", false), this.getBoolean("TransactionEditing.dateBasedAutoStatement", false), format, edwSettings);
        }
        return this.editingOptions;
    }

    public void setStartStateOptions(StartStateSettings options) {
        this.startStateOptions = options;
        this.setBoolean("StartState.remember.file", options.isRememberFile());
        this.setBoolean("StartState.remember.filter", options.isRememberFilter());
        this.setBoolean("StartState.remember.tabsOrder", options.isRememberTabsOrder());
        this.setBoolean("StartState.remember.columnsWidth", options.isRememberColumnsWidth());
        this.setBoolean("StartState.remember.columnsOrder", options.isRememberColumnsOrder());
        this.setBoolean("StartState.remember.hiddenColumns", options.isRememberHiddenColumns());
        this.setBoolean("StartState.remember.rowSorterKeys", options.isRememberRowsSortKeys());
    }

    public StartStateSettings getStartStateOptions() {
        if (this.startStateOptions == null) {
            this.startStateOptions = new StartStateSettings(this.getBoolean("StartState.remember.file", true), this.getBoolean("StartState.remember.filter", false), this.getBoolean("StartState.remember.tabsOrder", true), this.getBoolean("StartState.remember.columnsWidth", true), this.getBoolean("StartState.remember.columnsOrder", true), this.getBoolean("StartState.remember.hiddenColumns", true), this.getBoolean("StartState.remember.rowSorterKeys", false));
        }
        return this.startStateOptions;
    }

    public static boolean canSave() {
        return INSTANCE != null;
    }

    public Font getDefaultFont() {
        Font trueDefault = FontUtils.getDefaultFont();
        if (trueDefault == null) {
            return null;
        }
        String fontName = this.getProperty(FONT_NAME);
        if (fontName != null) {
            for (Font font : FontUtils.getAvailableTextFonts(this.getLocale())) {
                if (!fontName.equals(font.getName())) continue;
                return new Font(fontName, 0, 12);
            }
        }
        return trueDefault;
    }

    public void setDefaultFont(String fontName) {
        if (fontName == null) {
            this.removeProperty(FONT_NAME);
        } else {
            this.setProperty(FONT_NAME, fontName);
        }
    }

    private float getFloat(String key, float defaultValue) {
        try {
            String property = this.properties.getProperty(key);
            return property == null ? defaultValue : Float.parseFloat(property);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private void setFloat(String key, float value) {
        Preferences pref = INSTANCE;
        pref.setProperty(key, Float.toString(value));
    }

    public float getFontSizeRatio() {
        return this.getFloat(FONT_SIZE_RATIO, 1.0f);
    }

    public void setFontSizeRatio(float f) {
        this.setFloat(FONT_SIZE_RATIO, f);
    }
}

