/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.accountsummary;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.table.JTable;
import com.fathzer.soft.ajlib.swing.table.NimbusPatchBooleanTableCellRenderer;
import com.fathzer.soft.ajlib.swing.table.RowSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.accountsummary.AccountsSummaryTableModel;
import net.yapbam.gui.dialogs.EditAccountDialog;
import net.yapbam.gui.util.CellRenderer;
import net.yapbam.gui.util.JTableUtils;
import net.yapbam.gui.util.SplitPane;
import net.yapbam.util.NumberUtils;

public class AccountsSummaryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane tablePanel = null;
    private JTable table = null;
    private AccountsSummaryTableModel model;
    private SplitPane splitPane;
    private GlobalData data;
    private JScrollPane notePane;
    private JTextArea notesField;
    private JPanel bottomPanel;
    private JLabel lblNotesLabel;
    private JPanel editPanel;
    private JButton editButton;

    public AccountsSummaryPanel() {
        this.initialize();
    }

    public AccountsSummaryPanel(GlobalData data) {
        this.data = data;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSplitPane(), "Center");
    }

    private SplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new SplitPane(0, true);
            this.splitPane.setTopComponent(this.getTablePanel());
            this.splitPane.setBottomComponent(this.getBottomPanel());
            this.splitPane.setDividerVisible(false);
        }
        return this.splitPane;
    }

    private JScrollPane getTablePanel() {
        if (this.tablePanel == null) {
            this.tablePanel = new JScrollPane(this.getTable());
        }
        return this.tablePanel;
    }

    JTable getTable() {
        if (this.table == null) {
            this.table = new TotalTable();
            this.model = new AccountsSummaryTableModel(this.table, this.data);
            this.table.setModel(this.model);
            this.table.setRowSorter(new RowSorter<AccountsSummaryTableModel>(this.model));
            this.table.setDefaultRenderer(Boolean.class, new NimbusPatchBooleanTableCellRenderer());
            this.table.setDefaultRenderer(Object.class, new MyRenderer());
            this.table.setDefaultRenderer(Double.class, new MyRenderer());
            this.table.setSelectionMode(0);
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        Account account = AccountsSummaryPanel.this.getSelectedAccount();
                        if (account != null) {
                            if (!AccountsSummaryPanel.this.getSplitPane().isDividerVisible()) {
                                AccountsSummaryPanel.this.getSplitPane().setDividerLocation(0.5);
                            }
                            AccountsSummaryPanel.this.getNotesField().setText(account.getComment() == null ? "" : account.getComment());
                        }
                        AccountsSummaryPanel.this.getSplitPane().setDividerVisible(account != null);
                        AccountsSummaryPanel.this.getBottomPanel().setVisible(account != null);
                    }
                }
            });
            JTableUtils.fixColumnSize(this.table, 0, 10);
        }
        return this.table;
    }

    private Account getSelectedAccount() {
        int selected = this.table.getSelectedRow();
        boolean accountIsSelected = selected >= 0 && selected < this.data.getAccountsNumber();
        return accountIsSelected ? this.data.getAccount(this.table.convertRowIndexToModel(selected)) : null;
    }

    private JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new BorderLayout());
            this.bottomPanel.add(this.getNotePane());
            this.bottomPanel.add((Component)this.getLblNotesLabel(), "North");
            this.bottomPanel.add((Component)this.getEditPanel(), "South");
            this.bottomPanel.setVisible(false);
        }
        return this.bottomPanel;
    }

    private JLabel getLblNotesLabel() {
        if (this.lblNotesLabel == null) {
            this.lblNotesLabel = new JLabel(LocalizationData.get("AccountDialog.notes"));
        }
        return this.lblNotesLabel;
    }

    private JScrollPane getNotePane() {
        if (this.notePane == null) {
            this.notePane = new JScrollPane(this.getNotesField());
        }
        return this.notePane;
    }

    private JTextArea getNotesField() {
        if (this.notesField == null) {
            this.notesField = new JTextArea();
            this.notesField.setEditable(false);
            this.notesField.setLineWrap(true);
            this.notesField.setWrapStyleWord(true);
        }
        return this.notesField;
    }

    private JPanel getEditPanel() {
        if (this.editPanel == null) {
            this.editPanel = new JPanel();
            GridBagLayout gblEditPanel = new GridBagLayout();
            this.editPanel.setLayout(gblEditPanel);
            GridBagConstraints gbcEditButton = new GridBagConstraints();
            gbcEditButton.anchor = 17;
            gbcEditButton.weightx = 1.0;
            gbcEditButton.gridx = 0;
            gbcEditButton.gridy = 0;
            this.editPanel.add((Component)this.getEditButton(), gbcEditButton);
        }
        return this.editPanel;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton(LocalizationData.get("GenericButton.edit"), IconManager.get(IconManager.Name.EDIT_ACCOUNT));
            this.editButton.setToolTipText(LocalizationData.get("AccountManager.editAccount.toolTip"));
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Account account = AccountsSummaryPanel.this.getSelectedAccount();
                    if (account != null) {
                        EditAccountDialog.edit(AccountsSummaryPanel.this.data, Utils.getOwnerWindow(AccountsSummaryPanel.this.getEditButton()), account);
                        int index = AccountsSummaryPanel.this.getTable().convertRowIndexToView(AccountsSummaryPanel.this.data.indexOf(account));
                        AccountsSummaryPanel.this.getTable().getSelectionModel().setSelectionInterval(index, index);
                    }
                }
            });
        }
        return this.editButton;
    }

    private class MyRenderer
    extends CellRenderer {
        private static final long serialVersionUID = 1L;

        private MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(javax.swing.JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int rowCount = table.getModel().getRowCount();
            Font font = super.getFont();
            int style = font.getStyle();
            if (row == rowCount) {
                style |= 1;
                isSelected = false;
            } else {
                int mask = Integer.MIN_VALUE;
                style &= mask;
            }
            super.setFont(font.deriveFont(style, font.getSize2D()));
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class TotalTable
    extends JTable {
        private TotalTable() {
        }

        @Override
        public int getRowCount() {
            int rowCount = super.getRowCount();
            if (rowCount > 1) {
                ++rowCount;
            }
            return rowCount;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < super.getRowCount()) {
                return super.getValueAt(row, column);
            }
            if ((column = this.convertColumnIndexToModel(column)) == 0) {
                return null;
            }
            if (column == 1) {
                return LocalizationData.get("BudgetPanel.sum");
            }
            AccountsSummaryTableModel model = (AccountsSummaryTableModel)this.getModel();
            Number result = column == 5 || column == 6 ? (Number)0L : (Number)0.0;
            for (int i = 0; i < AccountsSummaryPanel.this.data.getAccountsNumber(); ++i) {
                if (!((Boolean)model.getValueAt(i, 0)).booleanValue()) continue;
                result = NumberUtils.add(result, (Number)model.getValueAt(i, column));
            }
            return result;
        }

        @Override
        public int convertRowIndexToModel(int viewRowIndex) {
            if (viewRowIndex < super.getRowCount()) {
                return super.convertRowIndexToModel(viewRowIndex);
            }
            return super.getRowCount();
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            if (row == this.getRowCount() - 1 && this.convertColumnIndexToModel(column) == 0) {
                renderer = this.getDefaultRenderer(Object.class);
                column = 1;
                JLabel component = (JLabel)super.prepareRenderer(renderer, row, column);
                component.setText("");
                return component;
            }
            return super.prepareRenderer(renderer, row, column);
        }
    }
}

