/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.accountsummary;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.yapbam.data.GlobalData;
import net.yapbam.data.event.AccountAddedEvent;
import net.yapbam.data.event.AccountRemovedEvent;
import net.yapbam.data.event.CategoryAddedEvent;
import net.yapbam.data.event.CategoryPropertyChangedEvent;
import net.yapbam.data.event.CategoryRemovedEvent;
import net.yapbam.data.event.CheckbookAddedEvent;
import net.yapbam.data.event.CheckbookPropertyChangedEvent;
import net.yapbam.data.event.CheckbookRemovedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.IsArchivedChangedEvent;
import net.yapbam.data.event.IsLockedChangedEvent;
import net.yapbam.data.event.ModeAddedEvent;
import net.yapbam.data.event.ModePropertyChangedEvent;
import net.yapbam.data.event.ModeRemovedEvent;
import net.yapbam.data.event.NeedToBeSavedChangedEvent;
import net.yapbam.data.event.PasswordChangedEvent;
import net.yapbam.data.event.PeriodicalTransactionsAddedEvent;
import net.yapbam.data.event.PeriodicalTransactionsRemovedEvent;
import net.yapbam.data.event.URIChangedEvent;
import net.yapbam.gui.LocalizationData;

class AccountsSummaryTableModel
extends AbstractTableModel {
    static final int SELECT_COLUMN = 0;
    static final int ACCOUNT_COLUMN = 1;
    static final int CURRENT_BALANCE_COLUMN = 2;
    static final int FINAL_BALANCE_COLUMN = 3;
    static final int CHECKED_BALANCE_COLUMN = 4;
    static final int NB_TRANSACTIONS_COLUMN = 5;
    static final int NB_UNCHECKED_TRANSACTIONS_COLUMN = 6;
    private static final long serialVersionUID = 1L;
    private static final Set<Class<? extends DataEvent>> IGNORED_EVENTS = new HashSet<Class<? extends DataEvent>>();
    private GlobalData data;
    private List<Boolean> accountSelected;

    AccountsSummaryTableModel(JTable table, GlobalData data) {
        this.data = data;
        this.accountSelected = new ArrayList<Boolean>();
        this.setAllAccountSelected();
        this.data.addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (!IGNORED_EVENTS.contains(event.getClass())) {
                    if (event instanceof EverythingChangedEvent) {
                        AccountsSummaryTableModel.this.setAllAccountSelected();
                    } else if (event instanceof AccountAddedEvent) {
                        AccountsSummaryTableModel.this.accountSelected.add(Boolean.TRUE);
                    } else if (event instanceof AccountRemovedEvent) {
                        int index = ((AccountRemovedEvent)event).getIndex();
                        AccountsSummaryTableModel.this.accountSelected.remove(index);
                    }
                    AccountsSummaryTableModel.this.fireTableDataChanged();
                }
            }
        });
    }

    private void setAllAccountSelected() {
        this.accountSelected.clear();
        for (int i = 0; i < this.data.getAccountsNumber(); ++i) {
            this.accountSelected.add(Boolean.TRUE);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        if (columnIndex == 1) {
            return Object.class;
        }
        if (columnIndex == 5 || columnIndex == 6) {
            return Long.class;
        }
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        if (columnIndex == 1) {
            return LocalizationData.get("Transaction.account");
        }
        if (columnIndex == 2) {
            return LocalizationData.get("AccountsSummary.CurrentBalance");
        }
        if (columnIndex == 3) {
            return LocalizationData.get("AccountsSummary.FinalBalance");
        }
        if (columnIndex == 4) {
            return LocalizationData.get("AccountsSummary.CheckedBalance");
        }
        if (columnIndex == 5) {
            return LocalizationData.get("AccountsSummary.TransactionsNumber");
        }
        if (columnIndex == 6) {
            return LocalizationData.get("MainMenuBar.notChecked");
        }
        return "?";
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.getAccountsNumber();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.accountSelected.get(rowIndex);
        }
        if (columnIndex == 1) {
            return this.data.getAccount(rowIndex).getName();
        }
        if (columnIndex == 2) {
            return this.data.getAccount(rowIndex).getBalanceData().getCurrentBalance();
        }
        if (columnIndex == 3) {
            return this.data.getAccount(rowIndex).getBalanceData().getFinalBalance();
        }
        if (columnIndex == 4) {
            return this.data.getAccount(rowIndex).getBalanceData().getCheckedBalance();
        }
        if (columnIndex == 5) {
            return this.data.getAccount(rowIndex).getTransactionsNumber();
        }
        if (columnIndex == 6) {
            return this.data.getAccount(rowIndex).getUncheckedTransactionsNumber();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return rowIndex < this.getRowCount() && columnIndex == 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.accountSelected.set(rowIndex, (Boolean)aValue);
        this.fireTableDataChanged();
    }

    static {
        IGNORED_EVENTS.add(CategoryAddedEvent.class);
        IGNORED_EVENTS.add(CategoryRemovedEvent.class);
        IGNORED_EVENTS.add(CategoryPropertyChangedEvent.class);
        IGNORED_EVENTS.add(CheckbookAddedEvent.class);
        IGNORED_EVENTS.add(CheckbookRemovedEvent.class);
        IGNORED_EVENTS.add(CheckbookPropertyChangedEvent.class);
        IGNORED_EVENTS.add(ModeAddedEvent.class);
        IGNORED_EVENTS.add(ModeRemovedEvent.class);
        IGNORED_EVENTS.add(ModePropertyChangedEvent.class);
        IGNORED_EVENTS.add(NeedToBeSavedChangedEvent.class);
        IGNORED_EVENTS.add(PasswordChangedEvent.class);
        IGNORED_EVENTS.add(PeriodicalTransactionsAddedEvent.class);
        IGNORED_EVENTS.add(PeriodicalTransactionsRemovedEvent.class);
        IGNORED_EVENTS.add(URIChangedEvent.class);
        IGNORED_EVENTS.add(IsLockedChangedEvent.class);
        IGNORED_EVENTS.add(IsArchivedChangedEvent.class);
    }
}

