/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.dialogs.update.CheckUpdateDialog;
import net.yapbam.update.VersionManager;
import net.yapbam.util.ApplicationContext;
import net.yapbam.util.DateUtils;
import net.yapbam.util.Portable;
import org.slf4j.LoggerFactory;

public class CheckNewReleaseAction
extends AbstractAction {
    public static final String LAST_UPDATE_CHECK_KEY = "net.yapbam.lastUpdateCheck";
    private Window owner;

    public CheckNewReleaseAction(Window owner) {
        super(LocalizationData.get("MainMenu.CheckUpdate"));
        this.putValue("ShortDescription", LocalizationData.get("MainMenu.CheckUpdate.ToolTip"));
        this.owner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CheckUpdateDialog.check(this.owner, false, false);
    }

    public static void doAutoCheck(Window owner) {
        boolean forced;
        if (Preferences.INSTANCE.isFirstRun()) {
            int option = -1;
            if (!Portable.isWebStarted()) {
                String yes = LocalizationData.get("GenericButton.yes");
                option = JOptionPane.showOptionDialog(owner, LocalizationData.get("MainMenu.CheckUpdate.FirstRun.message"), LocalizationData.get("MainMenu.CheckUpdate.FirstRun.title"), 0, 3, null, new String[]{yes, LocalizationData.get("GenericButton.no")}, yes);
            }
            Preferences.INSTANCE.setAutoUpdate(-option, false);
        }
        int lastCheck = DateUtils.dateToInteger(YapbamState.INSTANCE.getDate(LAST_UPDATE_CHECK_KEY));
        int releaseDate = DateUtils.dateToInteger(ApplicationContext.getVersion().getReleaseDate());
        int today = DateUtils.dateToInteger(new Date());
        int days = Preferences.INSTANCE.getAutoUpdatePeriod();
        boolean prefChoice = days >= 0 && today - lastCheck >= days;
        boolean bl = forced = !Preferences.INSTANCE.isFirstRun() && today - Math.max(releaseDate, lastCheck) > 30;
        if (prefChoice || forced) {
            if (Portable.isWebStarted()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VersionManager.getUpdateInformation();
                        }
                        catch (IOException e) {
                            LoggerFactory.getLogger(CheckNewReleaseAction.class).warn("Unable to contact yapbam site", e);
                        }
                    }
                }).start();
            } else {
                CheckUpdateDialog.check(owner, true, forced);
            }
        }
    }
}

