/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration;

import com.fathzer.soft.ajlib.swing.table.JTableListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.yapbam.gui.YapbamState;

public abstract class AbstractListAdministrationPanel<V>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable jTable = null;
    private JScrollPane jScrollPane = null;
    private JPanel southPanel = null;
    private JButton newButton = null;
    private JButton editButton = null;
    private JButton duplicateButton = null;
    private JButton deleteButton = null;
    private Action newButtonAction;
    private Action editButtonAction;
    private Action duplicateButtonAction;
    private Action deleteButtonAction;
    protected V data;

    public AbstractListAdministrationPanel() {
        this(null);
    }

    public AbstractListAdministrationPanel(V data) {
        this.data = data;
        this.initialize();
    }

    protected abstract Action getNewButtonAction();

    protected abstract Action getEditButtonAction();

    protected abstract Action getDeleteButtonAction();

    protected abstract Action getDuplicateButtonAction();

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSouthPanel(), "South");
        this.add((Component)this.getJScrollPane(), "Center");
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.editButtonAction != null) {
            actions.add(this.editButtonAction);
        }
        if (this.duplicateButtonAction != null) {
            actions.add(this.duplicateButtonAction);
        }
        if (this.deleteButtonAction != null) {
            actions.add(this.deleteButtonAction);
        }
        this.jTable.addMouseListener(new JTableListener(actions.toArray(new Action[actions.size()]), this.editButtonAction));
        this.jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AbstractListAdministrationPanel.this.refreshActions();
            }
        });
        this.refreshActions();
    }

    protected void refreshActions() {
        boolean ok;
        boolean bl = ok = this.getJTable().getSelectedRow() >= 0;
        if (this.editButtonAction != null) {
            this.editButtonAction.setEnabled(ok);
        }
        if (this.duplicateButtonAction != null) {
            this.duplicateButtonAction.setEnabled(ok);
        }
        if (this.deleteButtonAction != null) {
            this.deleteButtonAction.setEnabled(ok);
        }
    }

    protected JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = this.instantiateJTable();
            this.jTable.getSelectionModel().setSelectionMode(0);
        }
        return this.jTable;
    }

    protected abstract JTable instantiateJTable();

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JPanel getSouthPanel() {
        if (this.southPanel == null) {
            Insets rightInset;
            this.southPanel = new JPanel();
            this.southPanel.setLayout(new GridBagLayout());
            Component top = this.getTopComponent();
            if (top != null) {
                GridBagConstraints gridBagConstraintsTop = new GridBagConstraints();
                gridBagConstraintsTop.gridwidth = 0;
                gridBagConstraintsTop.weightx = 1.0;
                gridBagConstraintsTop.fill = 2;
                this.southPanel.add(top, gridBagConstraintsTop);
            }
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            Insets leftInset = new Insets(0, 5, this.getBottomInset(), 0);
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(0, 0, this.getBottomInset(), 0);
            this.southPanel.add((Component)this.getNewButton(), gridBagConstraints1);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = leftInset;
            gridBagConstraints.gridy = 1;
            if (this.getEditButton() != null) {
                this.southPanel.add((Component)this.getEditButton(), gridBagConstraints);
            }
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 2;
            gridBagConstraints11.insets = leftInset;
            gridBagConstraints11.gridy = 1;
            if (this.getDuplicateButton() != null) {
                this.southPanel.add((Component)this.getDuplicateButton(), gridBagConstraints11);
            }
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = leftInset;
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.gridy = 1;
            this.southPanel.add((Component)this.getDeleteButton(), gridBagConstraints2);
            Component rightComponent = this.getRightComponent();
            if (rightComponent == null) {
                rightComponent = new JLabel(" ");
            }
            GridBagConstraints gbcLblToto = new GridBagConstraints();
            gbcLblToto.anchor = 13;
            gbcLblToto.insets = rightInset = new Insets(0, 5, this.getBottomInset(), 0);
            gbcLblToto.gridx = 4;
            gbcLblToto.gridy = 1;
            gbcLblToto.weightx = 1.0;
            this.southPanel.add(rightComponent, gbcLblToto);
        }
        return this.southPanel;
    }

    protected JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new JButton();
            this.newButtonAction = this.getNewButtonAction();
            this.newButton.setAction(this.newButtonAction);
        }
        return this.newButton;
    }

    protected JButton getEditButton() {
        if (this.editButton == null) {
            this.editButtonAction = this.getEditButtonAction();
            if (this.editButtonAction != null) {
                this.editButton = new JButton();
                this.editButton.setAction(this.editButtonAction);
            }
        }
        return this.editButton;
    }

    protected JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton();
            this.deleteButtonAction = this.getDeleteButtonAction();
            this.deleteButton.setAction(this.deleteButtonAction);
        }
        return this.deleteButton;
    }

    private JButton getDuplicateButton() {
        if (this.duplicateButton == null) {
            this.duplicateButtonAction = this.getDuplicateButtonAction();
            if (this.duplicateButtonAction != null) {
                this.duplicateButton = new JButton();
                this.duplicateButton.setAction(this.duplicateButtonAction);
            }
        }
        return this.duplicateButton;
    }

    public void restoreState() {
        YapbamState.INSTANCE.restoreState(this.getJTable(), this.getStatePrefix());
    }

    protected String getStatePrefix() {
        return this.getClass().getCanonicalName();
    }

    public void saveState() {
        YapbamState.INSTANCE.saveState(this.getJTable(), this.getStatePrefix());
    }

    protected Component getRightComponent() {
        return null;
    }

    protected Component getTopComponent() {
        return null;
    }

    protected int getBottomInset() {
        return 0;
    }
}

