/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.administration.AbstractAdministrationPanel;
import net.yapbam.gui.administration.AccountListPanel;
import net.yapbam.gui.administration.AdministrationModeListPanel;
import net.yapbam.gui.dialogs.checkbook.CheckbookListPanel;

public class AccountAdministrationPanel
extends JPanel
implements AbstractAdministrationPanel {
    private static final long serialVersionUID = 1L;
    private AccountListPanel accountListPanel = null;
    private AdministrationModeListPanel modeListPanel = null;
    private CheckbookListPanel checkbookListPanel = null;
    private GlobalData data;

    public AccountAdministrationPanel(GlobalData data) {
        this.data = data;
        this.initialize();
        final JTable jTable = this.getAccountListPanel().getJTable();
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int viewRow = jTable.getSelectedRow();
                    int row = viewRow < 0 ? viewRow : jTable.convertRowIndexToModel(viewRow);
                    Account account = row >= 0 ? AccountAdministrationPanel.this.data.getAccount(row) : null;
                    AccountAdministrationPanel.this.getModeListPanel().setContent(account);
                    AccountAdministrationPanel.this.getCheckbookListPanel().setContent(account);
                }
            }
        });
    }

    public AccountAdministrationPanel() {
        this(new GlobalData());
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridy = 1;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getAccountListPanel(), gridBagConstraints);
        this.add((Component)this.getModeListPanel(), gridBagConstraints1);
        this.add((Component)this.getCheckbookListPanel(), gridBagConstraints3);
    }

    private AccountListPanel getAccountListPanel() {
        if (this.accountListPanel == null) {
            this.accountListPanel = new AccountListPanel(this.data);
        }
        return this.accountListPanel;
    }

    private AdministrationModeListPanel getModeListPanel() {
        if (this.modeListPanel == null) {
            this.modeListPanel = new AdministrationModeListPanel(this.data);
            this.modeListPanel.setBorder(BorderFactory.createTitledBorder(null, LocalizationData.get("AccountDialog.modes.border.title"), 0, 0));
        }
        return this.modeListPanel;
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void restoreState() {
        this.accountListPanel.restoreState();
        this.modeListPanel.restoreState();
        this.checkbookListPanel.restoreState();
    }

    @Override
    public void saveState() {
        this.accountListPanel.saveState();
        this.modeListPanel.saveState();
        this.checkbookListPanel.saveState();
    }

    @Override
    public String getPanelTitle() {
        return LocalizationData.get("AccountManager.title");
    }

    @Override
    public String getPanelToolTip() {
        return LocalizationData.get("AccountManager.toolTip");
    }

    private CheckbookListPanel getCheckbookListPanel() {
        if (this.checkbookListPanel == null) {
            this.checkbookListPanel = new CheckbookListPanel(this.data);
            this.checkbookListPanel.setBorder(BorderFactory.createTitledBorder(null, LocalizationData.get("checkbookDialog.border.title"), 0, 0));
        }
        return this.checkbookListPanel;
    }
}

