/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.yapbam.data.FilteredData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.administration.AbstractAdministrationPanel;
import net.yapbam.gui.administration.AccountAdministrationPanel;
import net.yapbam.gui.administration.CategoryListPanel;
import net.yapbam.gui.administration.PeriodicalTransactionListPanel;
import net.yapbam.gui.administration.filter.FilterListPanel;
import net.yapbam.gui.widget.PanelWithOverlay;
import net.yapbam.gui.widget.TabbedPane;

public class AdministrationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FilteredData data;
    private AbstractAdministrationPanel[] panels;
    private TabbedPane tabbedPane;
    private JLayeredPane layeredPane;
    private JCheckBox ignoreFilter;
    private PeriodicalTransactionListPanel periodicalTransactionsPanel;

    public AdministrationPanel(FilteredData filteredData) {
        this.data = filteredData;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getLayeredPane(), "Center");
        this.getTabbedPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AdministrationPanel.this.getIgnoreFilter().setVisible(AdministrationPanel.this.getTabbedPane().getSelectedComponent() instanceof PeriodicalTransactionListPanel);
            }
        });
    }

    TabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new TabbedPane();
            this.panels = new AbstractAdministrationPanel[]{this.getPeriodicalTransactionsPanel(), new AccountAdministrationPanel(this.data.getGlobalData()), new CategoryListPanel(this.data.getGlobalData()), new FilterListPanel(this.data.getGlobalData())};
            for (int i = 0; i < this.panels.length; ++i) {
                this.tabbedPane.addTab(this.panels[i].getPanelTitle(), null, this.panels[i].getPanel(), this.panels[i].getPanelToolTip());
            }
        }
        return this.tabbedPane;
    }

    private PeriodicalTransactionListPanel getPeriodicalTransactionsPanel() {
        if (this.periodicalTransactionsPanel == null) {
            this.periodicalTransactionsPanel = new PeriodicalTransactionListPanel(this.data);
        }
        return this.periodicalTransactionsPanel;
    }

    void saveState() {
        YapbamState.INSTANCE.saveState(this.getTabbedPane(), this.getClass().getCanonicalName());
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i].saveState();
        }
    }

    void restoreState() {
        YapbamState.INSTANCE.restoreState(this.getTabbedPane(), this.getClass().getCanonicalName());
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i].restoreState();
        }
    }

    private JLayeredPane getLayeredPane() {
        if (this.layeredPane == null) {
            this.layeredPane = new PanelWithOverlay(this.getTabbedPane(), this.getIgnoreFilter());
        }
        return this.layeredPane;
    }

    private JCheckBox getIgnoreFilter() {
        if (this.ignoreFilter == null) {
            this.ignoreFilter = new JCheckBox(LocalizationData.get("PeriodicalTransactionManager.ignoreFilter"));
            this.ignoreFilter.setToolTipText(LocalizationData.get("PeriodicalTransactionManager.ignoreFilter.tooltip"));
            this.ignoreFilter.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AdministrationPanel.this.getPeriodicalTransactionsPanel().setIgnoreFilter(AdministrationPanel.this.ignoreFilter.isSelected());
                }
            });
            this.ignoreFilter.setSelected(true);
        }
        return this.ignoreFilter;
    }
}

