/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.table.JTable;
import com.fathzer.soft.ajlib.swing.widget.CharWidget;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.data.comparator.CategoryComparator;
import net.yapbam.data.event.CategoryAddedEvent;
import net.yapbam.data.event.CategoryRemovedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.SubCategorySeparatorChangedEvent;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.administration.AbstractAdministrationPanel;
import net.yapbam.gui.administration.AbstractListAdministrationPanel;
import net.yapbam.gui.dialogs.CategoryDialog;

public class CategoryListPanel
extends AbstractListAdministrationPanel<GlobalData>
implements AbstractAdministrationPanel {
    private static final long serialVersionUID = 1L;
    private CharWidget subcategorySeparator;

    public CategoryListPanel(GlobalData data) {
        super(data);
    }

    @Override
    protected javax.swing.JTable instantiateJTable() {
        JTable table = new JTable(this.getTableModel()){

            @Override
            public String getToolTipText(MouseEvent e) {
                return LocalizationData.get("CategoryManager.nameColumn.toolTip");
            }
        };
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (CategoryListPanel.this.getJTable().isEditing()) {
                    CategoryListPanel.this.getJTable().getCellEditor().cancelCellEditing();
                }
            }
        });
        return table;
    }

    private TableModel getTableModel() {
        return new CategoryTableModel();
    }

    @Override
    protected Action getNewButtonAction() {
        return new NewAction();
    }

    @Override
    protected Action getDeleteButtonAction() {
        return new DeleteAction();
    }

    @Override
    protected Action getEditButtonAction() {
        return null;
    }

    @Override
    protected Action getDuplicateButtonAction() {
        return null;
    }

    private boolean isUsed(Category category) {
        int i;
        GlobalData gData = (GlobalData)this.data;
        for (i = 0; i < gData.getTransactionsNumber(); ++i) {
            if (!gData.getTransaction(i).hasCategory(category)) continue;
            return true;
        }
        for (i = 0; i < gData.getPeriodicalTransactionsNumber(); ++i) {
            if (!gData.getPeriodicalTransaction(i).hasCategory(category)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPanelTitle() {
        return LocalizationData.get("CategoryManager.title");
    }

    @Override
    public String getPanelToolTip() {
        return LocalizationData.get("CategoryManager.toolTip");
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void restoreState() {
    }

    @Override
    public void saveState() {
    }

    @Override
    protected Component getRightComponent() {
        JPanel result = new JPanel();
        result.add(new JLabel(LocalizationData.get("Subcategories.separatorField.title")));
        result.add(this.getSeparator());
        return result;
    }

    private JTextField getSeparator() {
        if (this.subcategorySeparator == null) {
            this.subcategorySeparator = new CharWidget();
            this.subcategorySeparator.setChar(Character.valueOf(((GlobalData)this.data).getSubCategorySeparator()));
            this.subcategorySeparator.setDefaultChar('.');
            ((GlobalData)this.data).addListener(new DataListener(){

                @Override
                public void processEvent(DataEvent event) {
                    if (event instanceof SubCategorySeparatorChangedEvent || event instanceof EverythingChangedEvent) {
                        CategoryListPanel.this.subcategorySeparator.setChar(Character.valueOf(((GlobalData)CategoryListPanel.this.data).getSubCategorySeparator()));
                    }
                }
            });
            this.subcategorySeparator.addPropertyChangeListener("char", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ((GlobalData)CategoryListPanel.this.data).setSubCategorySeparator(((Character)evt.getNewValue()).charValue());
                }
            });
            this.subcategorySeparator.setToolTipText(LocalizationData.get("Subcategories.separatorField.tooltip"));
        }
        return this.subcategorySeparator;
    }

    private final class NewAction
    extends AbstractAction {
        public NewAction() {
            super(LocalizationData.get("GenericButton.new"), IconManager.get(IconManager.Name.NEW_CATEGORY));
            this.putValue("ShortDescription", LocalizationData.get("CategoryManager.new.toolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CategoryDialog.open(Utils.getOwnerWindow(CategoryListPanel.this), (GlobalData)CategoryListPanel.this.data);
        }
    }

    private final class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            super(LocalizationData.get("GenericButton.delete"), IconManager.get(IconManager.Name.DELETE_CATEGORY));
            this.putValue("ShortDescription", LocalizationData.get("CategoryManager.delete.toolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CategoryListPanel.this.getJTable().getCellEditor() != null) {
                CategoryListPanel.this.getJTable().getCellEditor().cancelCellEditing();
            }
            int selectedRow = CategoryListPanel.this.getJTable().getSelectedRow();
            Category category = ((CategoryTableModel)CategoryListPanel.this.getJTable().getModel()).getCategory(selectedRow);
            boolean confirmed = true;
            if (CategoryListPanel.this.isUsed(category)) {
                String mess = "<HTML>" + LocalizationData.get("CategoryManager.deleteMessage.head") + "<BR>" + LocalizationData.get("CategoryManager.deleteMessage.confirm") + "</HTML>";
                Object[] options = new Object[]{LocalizationData.get("GenericButton.ok"), LocalizationData.get("GenericButton.cancel")};
                int ok = JOptionPane.showOptionDialog(CategoryListPanel.this.getJTable(), mess, LocalizationData.get("CategoryManager.deleteMessage.title"), 0, 3, null, options, options[1]);
                boolean bl = confirmed = ok == 0;
            }
            if (confirmed) {
                ((GlobalData)CategoryListPanel.this.data).remove(category);
            }
        }
    }

    private final class CategoryTableModel
    extends AbstractTableModel
    implements DataListener {
        Category[] content;

        CategoryTableModel() {
            ((GlobalData)CategoryListPanel.this.data).addListener(this);
            this.buildContent();
        }

        private void buildContent() {
            this.content = new Category[((GlobalData)CategoryListPanel.this.data).getCategoriesNumber() - 1];
            for (int i = 0; i < this.content.length; ++i) {
                this.content[i] = ((GlobalData)CategoryListPanel.this.data).getCategory(i + 1);
            }
            Arrays.sort(this.content, new CategoryComparator(CategoryListPanel.this.getLocale(), ((GlobalData)CategoryListPanel.this.data).getSubCategorySeparator()));
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return LocalizationData.get("Transaction.category");
            }
            return "?";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Category category = this.getCategory(rowIndex);
            return category.equals(Category.UNDEFINED) ? LocalizationData.get("Category.undefined") : category.getName();
        }

        Category getCategory(int row) {
            return this.content[row];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            String name = ((String)value).trim();
            String errorMessage = null;
            if (name.length() == 0) {
                errorMessage = LocalizationData.get("CategoryManager.error.message.empty");
            } else {
                Category category = ((GlobalData)CategoryListPanel.this.data).getCategory(name);
                if (category != null) {
                    if (category == this.getCategory(row)) {
                        return;
                    }
                    errorMessage = Formatter.format(LocalizationData.get("CategoryManager.error.message.alreadyUsed"), name);
                }
            }
            if (errorMessage != null) {
                JOptionPane.showMessageDialog(Utils.getOwnerWindow(CategoryListPanel.this), errorMessage, LocalizationData.get("CategoryManager.error.title"), 1);
                this.fireTableRowsUpdated(row, row);
            } else {
                ((GlobalData)CategoryListPanel.this.data).setName(this.getCategory(row), name);
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getRowCount() {
            return this.content.length;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void processEvent(DataEvent event) {
            if (event instanceof CategoryAddedEvent || event instanceof CategoryRemovedEvent || event instanceof EverythingChangedEvent) {
                this.buildContent();
                this.fireTableDataChanged();
            }
        }
    }
}

