/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration;

import java.awt.Component;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import net.yapbam.data.FilteredData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.actions.NewPeriodicalTransactionAction;
import net.yapbam.gui.administration.AbstractAdministrationPanel;
import net.yapbam.gui.administration.AbstractListAdministrationPanel;
import net.yapbam.gui.administration.DeletePeriodicalTransactionAction;
import net.yapbam.gui.administration.DuplicatePeriodicTransactionAction;
import net.yapbam.gui.administration.EditPeriodicalTransactionAction;
import net.yapbam.gui.administration.PeriodicalTransactionTableModel;
import net.yapbam.gui.administration.PeriodicalTransactionsStatPanel;
import net.yapbam.gui.administration.PeriodicalTransactionsTable;
import net.yapbam.gui.transactiontable.GeneratePeriodicalTransactionsAction;
import net.yapbam.gui.util.JTableUtils;

public class PeriodicalTransactionListPanel
extends AbstractListAdministrationPanel<FilteredData>
implements AbstractAdministrationPanel {
    private static final String STATE_PREFIX = "net.yapbam.periodicalTransactionAdministration.";
    private static final long serialVersionUID = 1L;
    private PeriodicalTransactionTableModel model;
    private PeriodicalTransactionsStatPanel statPanel;

    public PeriodicalTransactionListPanel(FilteredData data) {
        super(data);
    }

    @Override
    public String getPanelToolTip() {
        return LocalizationData.get("PeriodicalTransactionManager.toolTip");
    }

    @Override
    public String getPanelTitle() {
        return LocalizationData.get("PeriodicalTransactionManager.title");
    }

    @Override
    protected Component getRightComponent() {
        return new JButton(new GeneratePeriodicalTransactionsAction(((FilteredData)this.data).getGlobalData(), false));
    }

    @Override
    protected Component getTopComponent() {
        if (this.statPanel == null) {
            this.statPanel = new PeriodicalTransactionsStatPanel((FilteredData)this.data);
        }
        return this.statPanel;
    }

    @Override
    protected int getBottomInset() {
        return 5;
    }

    @Override
    protected Action getNewButtonAction() {
        return new NewPeriodicalTransactionAction(((FilteredData)this.data).getGlobalData());
    }

    @Override
    protected Action getEditButtonAction() {
        return new EditPeriodicalTransactionAction((PeriodicalTransactionsTable)this.getJTable());
    }

    @Override
    protected Action getDeleteButtonAction() {
        return new DeletePeriodicalTransactionAction(this);
    }

    @Override
    protected Action getDuplicateButtonAction() {
        return new DuplicatePeriodicTransactionAction((PeriodicalTransactionsTable)this.getJTable());
    }

    @Override
    protected JTable instantiateJTable() {
        return new PeriodicalTransactionsTable(this.getModel());
    }

    private PeriodicalTransactionTableModel getModel() {
        if (this.model == null) {
            this.model = new PeriodicalTransactionTableModel(this);
        }
        return this.model;
    }

    @Override
    protected String getStatePrefix() {
        return STATE_PREFIX;
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void restoreState() {
        super.restoreState();
        JTableUtils.fixColumnSize(this.getJTable(), 0, 0);
    }

    public void setIgnoreFilter(boolean ignore) {
        this.getModel().setIgnoreFilter(ignore);
        ((PeriodicalTransactionsStatPanel)this.getTopComponent()).setIgnoreFilter(ignore);
    }
}

