/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import javax.swing.JComponent;
import net.yapbam.data.FilteredData;
import net.yapbam.data.PeriodicalTransactionSimulationData;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.administration.PeriodicalTransactionDetailedStatPanel;
import net.yapbam.gui.widget.AbstractStatPanel;

public class PeriodicalTransactionsStatPanel
extends AbstractStatPanel<PeriodicalTransactionSimulationData, FilteredData> {
    public PeriodicalTransactionsStatPanel(FilteredData data) {
        super(data);
        this.getShowButton().setIcon(IconManager.get(IconManager.Name.SETTINGS));
    }

    @Override
    protected PeriodicalTransactionSimulationData buildData(FilteredData data) {
        return new PeriodicalTransactionSimulationData(data);
    }

    @Override
    protected JComponent buildDetails() {
        return new PeriodicalTransactionDetailedStatPanel((PeriodicalTransactionSimulationData)this.getData());
    }

    public void setIgnoreFilter(boolean ignore) {
        ((PeriodicalTransactionSimulationData)this.getData()).setIgnoreFilter(ignore);
    }

    @Override
    protected void setDeployed(boolean deployed) {
        super.setDeployed(deployed);
        this.getShowButton().setIcon(IconManager.get(deployed ? IconManager.Name.CLOSE : IconManager.Name.SETTINGS));
    }

    @Override
    protected void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints cShow = new GridBagConstraints();
        cShow.gridx = 0;
        cShow.anchor = 18;
        this.add((Component)this.getShowButton(), cShow);
        GridBagConstraints gbcSummaryLabel = new GridBagConstraints();
        gbcSummaryLabel.insets = new Insets(0, 5, 0, 0);
        gbcSummaryLabel.weightx = 1.0;
        gbcSummaryLabel.anchor = 17;
        gbcSummaryLabel.gridx = 2;
        this.add((Component)this.getSummary(), gbcSummaryLabel);
        GridBagConstraints cContent = new GridBagConstraints();
        cContent.anchor = 17;
        cContent.insets = new Insets(0, 5, 0, 0);
        cContent.gridx = 1;
        this.add((Component)this.getDetails(), cContent);
    }

    private String getPeriodWording() {
        PeriodicalTransactionDetailedStatPanel settings = (PeriodicalTransactionDetailedStatPanel)this.getDetails();
        if (settings.getNextMonth().isSelected()) {
            return LocalizationData.get("PeriodicalTransactionManager.nextMonth");
        }
        if (settings.getNext3months().isSelected()) {
            return LocalizationData.get("PeriodicalTransactionManager.nextQuarter");
        }
        if (settings.getNextYear().isSelected()) {
            return LocalizationData.get("PeriodicalTransactionManager.nextYear");
        }
        return "?";
    }

    @Override
    protected void doUpdate() {
        DecimalFormat ci = LocalizationData.getCurrencyInstance();
        String format = LocalizationData.get("PeriodicalTransactionManager.summary");
        this.getSummary().setText(MessageFormat.format(format, this.getPeriodWording(), ((PeriodicalTransactionSimulationData)this.getData()).getNbTransactions(), ci.format(-((PeriodicalTransactionSimulationData)this.getData()).getTotalExpenses()), ci.format(((PeriodicalTransactionSimulationData)this.getData()).getTotalReceips()), ci.format(((PeriodicalTransactionSimulationData)this.getData()).getTotalExpenses() + ((PeriodicalTransactionSimulationData)this.getData()).getTotalReceips())));
    }
}

