/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.archive;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.jclop.swing.URIChooserDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import net.yapbam.data.Account;
import net.yapbam.data.Archiver;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.TransactionsAddedEvent;
import net.yapbam.data.event.TransactionsRemovedEvent;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.archive.StatementSelectionDialog;
import net.yapbam.gui.persistence.PersistenceManager;
import net.yapbam.gui.persistence.YapbamDataWrapper;
import net.yapbam.gui.persistence.YapbamPersistenceManager;
import net.yapbam.util.ArrayUtils;

public class ArchiveAction
extends AbstractAction {
    private GlobalData data;

    public ArchiveAction(GlobalData data) {
        super(LocalizationData.get("Archive.menu.name"), IconManager.get(IconManager.Name.ARCHIVE));
        this.putValue("ShortDescription", LocalizationData.get("Archive.menu.tooltip"));
        this.data = data;
        data.addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (event instanceof EverythingChangedEvent || event instanceof TransactionsAddedEvent || event instanceof TransactionsRemovedEvent) {
                    ArchiveAction.this.refresh();
                }
            }
        });
        this.refresh();
    }

    private void refresh() {
        this.setEnabled(this.data.getTransactionsNumber() > 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final Window owner = Utils.getOwnerWindow((Component)e.getSource());
        URI uri = this.getArchiveURI(owner);
        if (uri == null) {
            return;
        }
        final GlobalData archiveData = new GlobalData();
        YapbamDataWrapper wrapper = new YapbamDataWrapper(archiveData);
        ReadErrorProcessor errProcessor = new ReadErrorProcessor();
        boolean readIsOk = YapbamPersistenceManager.MANAGER.read(owner, wrapper, uri, errProcessor);
        if (errProcessor.isNewFile()) {
            archiveData.setArchive(true);
            archiveData.setURI(uri);
        } else if (!readIsOk) {
            return;
        }
        CharSequence[] alerts = this.getAlerts(archiveData);
        if (!ArrayUtils.isAllNull(alerts) || !archiveData.isArchive()) {
            String cancel = LocalizationData.get("GenericButton.cancel");
            Object[] options = new String[]{LocalizationData.get("GenericButton.continue"), cancel};
            int continued = JOptionPane.showOptionDialog(owner, this.getAlertMessage(archiveData, alerts), LocalizationData.get("Generic.warning"), 2, 2, null, options, cancel);
            if (continued != 0) {
                return;
            }
        }
        StatementSelectionDialog filterDialog = new StatementSelectionDialog(owner, this.data, archiveData, alerts);
        filterDialog.setVisible(true);
        Collection selectedTransactions = (Collection)filterDialog.getResult();
        if (selectedTransactions == null || selectedTransactions.isEmpty()) {
            return;
        }
        final boolean old = archiveData.isArchive();
        Transaction[] transactions = selectedTransactions.toArray(new Transaction[selectedTransactions.size()]);
        Archiver archiver = new Archiver(){

            @Override
            protected boolean save(GlobalData data) {
                if (data == archiveData) {
                    archiveData.setArchive(old);
                }
                return YapbamPersistenceManager.MANAGER.save(owner, new YapbamDataWrapper(data));
            }
        };
        archiveData.setArchive(true);
        if (archiver.move(this.data, archiveData, transactions, filterDialog.isArchiveMode())) {
            JOptionPane.showMessageDialog(owner, Formatter.format(LocalizationData.get(filterDialog.isArchiveMode() ? "Archive.report" : "Archive.restore.report"), transactions.length));
        }
    }

    private URI getArchiveURI(Window owner) {
        URIChooserDialog dialog = YapbamPersistenceManager.MANAGER.getChooserDialog(owner);
        dialog.setSaveDialog(true);
        dialog.setConfirmIfExisting(false);
        dialog.setTitle(LocalizationData.get("Archive.selectionDialog.title"));
        dialog.setConfirmButtonUpdater(new URIChooserDialog.ConfirmButtonUpdater(){

            @Override
            public boolean update(JButton button, URI selectedURI, boolean existing) {
                if (selectedURI == null) {
                    return false;
                }
                button.setText(existing ? LocalizationData.get("GenericButton.select") : LocalizationData.get("GenericButton.new"));
                return true;
            }
        });
        return dialog.showDialog();
    }

    private CharSequence[] getAlerts(GlobalData archiveData) {
        CharSequence[] result = new CharSequence[this.data.getAccountsNumber()];
        for (int i = 0; i < this.data.getAccountsNumber(); ++i) {
            double arcFinal;
            Account account = this.data.getAccount(i);
            Account archiveAccount = archiveData.getAccount(account.getName());
            if (archiveAccount == null || GlobalData.AMOUNT_COMPARATOR.compare(arcFinal = archiveAccount.getBalanceData().getFinalBalance(), account.getInitialBalance()) == 0) continue;
            String strFinal = LocalizationData.getCurrencyInstance().format(arcFinal);
            String strInitial = LocalizationData.getCurrencyInstance().format(account.getInitialBalance());
            result[i] = Formatter.format(LocalizationData.get("Archive.accountBalancesNotMatch"), account.getName(), strFinal, strInitial);
        }
        return result;
    }

    private CharSequence getAlertMessage(GlobalData archiveData, CharSequence[] alerts) {
        StringBuilder builder = new StringBuilder();
        if (!archiveData.isArchive()) {
            builder.append("<HTML>");
            builder.append(LocalizationData.get("Archive.warning.notAnArchiveFile"));
            builder.append("<BR>");
        }
        for (int i = 0; i < alerts.length; ++i) {
            if (alerts[i] == null) continue;
            builder.append(builder.length() == 0 ? "<HTML>" : "<BR>");
            builder.append(alerts[i]);
        }
        if (builder.length() > 0) {
            builder.append("<BR>");
            builder.append("<BR>");
            builder.append(LocalizationData.get("Archive.accountBalancesNotMatchFinalMessage"));
            builder.append("</HTML>");
        }
        return builder;
    }

    private static final class ReadErrorProcessor
    implements PersistenceManager.ErrorProcessor {
        private boolean isNewFile = false;

        ReadErrorProcessor() {
        }

        @Override
        public boolean processError(Throwable e) {
            this.isNewFile = true;
            return e instanceof FileNotFoundException;
        }

        boolean isNewFile() {
            return this.isNewFile;
        }
    }
}

