/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.gui.dialogs.PredefinedDescriptionComputer;

abstract class AbstractPredefinedComputer
implements PredefinedDescriptionComputer {
    protected GlobalData data;
    protected long now;
    private Map<String, Double> map;

    protected AbstractPredefinedComputer(GlobalData data) {
        this.data = data;
        this.now = System.currentTimeMillis();
    }

    @Override
    public int getUnsortedSize() {
        return 3;
    }

    @Override
    public String[] getPredefined() {
        this.map = new HashMap<String, Double>();
        for (int i = 0; i < this.data.getTransactionsNumber(); ++i) {
            Transaction transaction = this.data.getTransaction(i);
            this.process(transaction);
        }
        LinkedList<Map.Entry<String, Double>> list = new LinkedList<Map.Entry<String, Double>>(this.map.entrySet());
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return -((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
            }
        });
        String[] array = new String[list.size()];
        Iterator iterator = list.iterator();
        for (int i = 0; i < array.length; ++i) {
            array[i] = (String)((Map.Entry)iterator.next()).getKey();
        }
        return array;
    }

    protected abstract void process(Transaction var1);

    protected final void add(String value, double ranking) {
        Double current = this.map.get(value);
        if (current == null) {
            this.map.put(value, ranking);
        } else {
            this.map.put(value, ranking + current);
        }
    }
}

