/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import java.awt.Window;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.BasicInputDialog;

public class CategoryDialog
extends BasicInputDialog<GlobalData, Category> {
    private static final long serialVersionUID = 1L;

    private CategoryDialog(Window owner, GlobalData data) {
        super(owner, LocalizationData.get("CategoryDialog.title"), data);
    }

    @Override
    protected String getLabel() {
        return LocalizationData.get("CategoryDialog.category");
    }

    @Override
    protected String getTooltip() {
        return LocalizationData.get("CategoryDialog.category.tooltip");
    }

    @Override
    protected Category buildResult() {
        return new Category(this.getField().getText().trim());
    }

    public static Category open(Window owner, GlobalData data) {
        CategoryDialog dialog = new CategoryDialog(owner, data);
        dialog.setVisible(true);
        Category newCategory = (Category)dialog.getResult();
        if (newCategory != null) {
            data.add(newCategory);
        }
        return newCategory;
    }

    @Override
    protected String getOkDisabledCause() {
        String name = this.getField().getText().trim();
        if (name.length() == 0) {
            return LocalizationData.get("CategoryDialog.err1");
        }
        if (((GlobalData)this.data).getCategory(name) != null) {
            return LocalizationData.get("CategoryDialog.err2");
        }
        return null;
    }
}

