/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.LinkEditDialog;
import net.yapbam.util.HtmlUtils;

public class CommentWidget
extends JPanel {
    private static final String BUTTON_TOOLTIP_DISABLED_KEY = "LinkEditor.button.tooltip.disabled";
    private static final long serialVersionUID = 1L;
    private TextWidget textField;
    private JLabel linkButton;

    public CommentWidget() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.add(this.getTextField());
        this.add((Component)this.getLinkButton(), "East");
    }

    private TextWidget getTextField() {
        if (this.textField == null) {
            this.textField = new TextWidget();
            this.textField.setColumns(10);
            this.textField.setToolTipText(LocalizationData.get("TransactionDialog.comment.tooltip"));
            this.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    CommentWidget.this.getLinkButton().setEnabled(false);
                    CommentWidget.this.linkButton.setToolTipText(LocalizationData.get(CommentWidget.BUTTON_TOOLTIP_DISABLED_KEY));
                }

                @Override
                public void focusGained(FocusEvent e) {
                    CommentWidget.this.getLinkButton().setEnabled(true);
                    CommentWidget.this.getLinkButton().setToolTipText(LocalizationData.get("LinkEditor.button.tooltip"));
                }
            });
        }
        return this.textField;
    }

    private JLabel getLinkButton() {
        if (this.linkButton == null) {
            this.linkButton = new JLabel(IconManager.get(IconManager.Name.LINK));
            this.linkButton.setToolTipText(LocalizationData.get(BUTTON_TOOLTIP_DISABLED_KEY));
            this.linkButton.setEnabled(false);
            this.linkButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (CommentWidget.this.linkButton.isEnabled()) {
                        Matcher link;
                        int start = CommentWidget.this.getTextField().getSelectionStart();
                        int end = CommentWidget.this.getTextField().getSelectionEnd();
                        String text = CommentWidget.this.getTextField().getSelectedText();
                        String url = null;
                        if (end != 0 && (link = HtmlUtils.getLink(CommentWidget.this.getTextField().getText(), start, end)) != null) {
                            text = link.group(1);
                            url = link.group(2);
                            start = link.start(1) - 1;
                            end = link.end(2) + 2;
                        }
                        LinkEditDialog dialog = new LinkEditDialog(Utils.getOwnerWindow(CommentWidget.this.getLinkButton()), new String[]{text, url});
                        dialog.setVisible(true);
                        String result = (String)dialog.getResult();
                        if (result != null) {
                            CommentWidget.this.getTextField().setSelectionStart(start);
                            CommentWidget.this.getTextField().setSelectionEnd(end);
                            CommentWidget.this.getTextField().replaceSelection(result);
                            CommentWidget.this.getTextField().setSelectionStart(start);
                            CommentWidget.this.getTextField().setSelectionEnd(start + result.length());
                        }
                    }
                }
            });
        }
        return this.linkButton;
    }

    public void setText(String comment) {
        this.getTextField().setText(comment);
    }

    public String getText() {
        return this.getTextField().getText();
    }
}

