/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.yapbam.data.Filter;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.filter.CustomFilterPanel;
import net.yapbam.gui.filter.SavePanel;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;

public class CustomFilterDialog
extends AbstractDialog<FilterData, Boolean> {
    private CustomFilterPanel filterPanel;

    public CustomFilterDialog(Window owner, FilterData data) {
        super(owner, LocalizationData.get("MainMenuBar.customizedFilter"), data);
        this.pack();
    }

    @Override
    protected Boolean buildResult() {
        return this.filterPanel.apply();
    }

    @Override
    protected JPanel createCenterPane() {
        return this.getFilterPanel();
    }

    @Override
    protected String getOkDisabledCause() {
        return this.filterPanel.getInconsistencyCause();
    }

    @Override
    protected JComponent createExtraComponent() {
        return new SavePanel(this.getFilterPanel());
    }

    protected CustomFilterPanel getFilterPanel() {
        if (this.filterPanel == null) {
            this.filterPanel = new CustomFilterPanel(((FilterData)this.data).getFilter(), ((FilterData)this.data).getGlobalData());
            this.filterPanel.addPropertyChangeListener("InconsistencyCause", new AutoUpdateOkButtonPropertyListener(this));
        }
        return this.filterPanel;
    }

    public static interface FilterData {
        public Filter getFilter();

        public GlobalData getGlobalData();
    }
}

