/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.LinkEditPanel;
import net.yapbam.util.HtmlUtils;

public class LinkEditDialog
extends AbstractDialog<String[], String> {
    private static final long serialVersionUID = 1L;
    private LinkEditPanel linkEditPanel;

    public LinkEditDialog(Window owner, String[] data) {
        super(owner, LocalizationData.get("LinkEditor.dialog.title"), LinkEditDialog.decode(data));
    }

    private static String[] decode(String[] data) {
        return new String[]{data[1] == null ? data[0] : HtmlUtils.decodeLinkName(data[0]), data[1]};
    }

    @Override
    protected JPanel createCenterPane() {
        this.linkEditPanel = new LinkEditPanel((String[])this.data);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LinkEditDialog.super.updateOkButtonEnabled();
            }
        };
        this.linkEditPanel.getTextField().addPropertyChangeListener("text", listener);
        this.linkEditPanel.getUrlField().addPropertyChangeListener("text", listener);
        return this.linkEditPanel;
    }

    @Override
    protected String buildResult() {
        if (this.linkEditPanel.getUrlField().getText().isEmpty()) {
            return this.linkEditPanel.getTextField().getText();
        }
        return HtmlUtils.toEncoded(this.linkEditPanel.getTextField().getText(), this.linkEditPanel.getUrlField().getText());
    }

    @Override
    protected String getOkDisabledCause() {
        if (this.linkEditPanel.getTextField().getText().isEmpty()) {
            return LocalizationData.get("LinkEditor.textIsEmpty");
        }
        if (!this.linkEditPanel.isURLOk()) {
            return LocalizationData.get("LinkEditor.incorrectURL");
        }
        return null;
    }
}

