/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.widget.IntegerWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.date.helpers.DayDateStepper;
import net.yapbam.date.helpers.DeferredValueDateComputer;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.widget.AutoSelectFocusListener;

class ModePanel
extends JPanel {
    static final String IS_SELECTED_PROPERTY = "IS_SELECTED";
    static final String IS_VALID_PROPERTY = "IS_VALID";
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private JComboBox combo;
    private JPanel relativePanel;
    private JPanel deferedPanel;
    private JPanel emptyPanel;
    private JCheckBox checkBook;
    private IntegerWidget relField;
    private IntegerWidget stopField;
    private IntegerWidget debtField;
    private JLabel comboLabel;
    private JLabel stopLabel;
    private JLabel debtLabel;
    private JLabel relLabel;
    private JCheckBox isSelectedBox;
    boolean lastValidity = true;

    ModePanel(String title, boolean checkBookOption) {
        super(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        this.setBorder(BorderFactory.createTitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 0;
        c.insets = insets;
        c.anchor = 17;
        this.isSelectedBox = new JCheckBox(title);
        this.isSelectedBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean ok = e.getStateChange() == 1;
                ModePanel.this.combo.setEnabled(ok);
                ModePanel.this.relField.setEnabled(ok);
                ModePanel.this.stopField.setEnabled(ok);
                ModePanel.this.debtField.setEnabled(ok);
                ModePanel.this.comboLabel.setEnabled(ok);
                ModePanel.this.stopLabel.setEnabled(ok);
                ModePanel.this.debtLabel.setEnabled(ok);
                ModePanel.this.relLabel.setEnabled(ok);
                if (ModePanel.this.checkBook != null) {
                    ModePanel.this.checkBook.setEnabled(ok);
                }
                if (!ok && ModePanel.this.checkBook != null) {
                    ModePanel.this.checkBook.setSelected(false);
                }
                ModePanel.this.firePropertyChange(ModePanel.IS_SELECTED_PROPERTY, !ok, ok);
                ModePanel.this.checkValidity();
            }
        });
        this.add((Component)this.isSelectedBox, c);
        GridBagConstraints comboConstraint = new GridBagConstraints();
        comboConstraint.gridx = 0;
        comboConstraint.gridy = 1;
        comboConstraint.anchor = 17;
        comboConstraint.insets = insets;
        comboConstraint.gridwidth = 1;
        this.comboLabel = new JLabel(LocalizationData.get("TransactionDialog.valueDate"));
        this.comboLabel.setEnabled(false);
        this.add((Component)this.comboLabel, comboConstraint);
        this.combo = new JComboBox<String>(new String[]{LocalizationData.get("ModeDialog.immediate"), LocalizationData.get("ModeDialog.relative"), LocalizationData.get("ModeDialog.deferred")});
        this.combo.setEditable(false);
        this.combo.setEnabled(false);
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ModePanel.this.combo.getSelectedIndex();
                ModePanel.this.emptyPanel.setVisible(index == 0);
                ModePanel.this.relativePanel.setVisible(index == 1);
                ModePanel.this.deferedPanel.setVisible(index == 2);
                ModePanel.this.checkValidity();
            }
        });
        GridBagConstraints cCombo = new GridBagConstraints();
        cCombo.anchor = 17;
        cCombo.gridy = 1;
        cCombo.gridx = 1;
        this.add((Component)this.combo, cCombo);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ModePanel.this.checkValidity();
            }
        };
        this.relativePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridy = 0;
        c2.insets = insets;
        c2.anchor = 17;
        this.relLabel = new JLabel(LocalizationData.get("ModeDialog.daysNumber"));
        this.relativePanel.add((Component)this.relLabel, c2);
        GridBagConstraints cRelField = new GridBagConstraints();
        cRelField.gridx = 1;
        cRelField.weightx = 1.0;
        cRelField.anchor = 17;
        this.relField = new IntegerWidget();
        this.relField.addFocusListener(AutoSelectFocusListener.INSTANCE);
        this.relField.addPropertyChangeListener("VALUE_PROPERTY", listener);
        this.relField.setColumns(2);
        this.relativePanel.add((Component)this.relField, cRelField);
        this.relativePanel.setVisible(false);
        this.deferedPanel = new JPanel(new GridBagLayout());
        GridBagConstraints stopLabelConstraints = new GridBagConstraints();
        stopLabelConstraints.insets = insets;
        stopLabelConstraints.anchor = 17;
        this.stopLabel = new JLabel(LocalizationData.get("ModeDialog.stop"));
        this.deferedPanel.add((Component)this.stopLabel, stopLabelConstraints);
        GridBagConstraints cStopField = new GridBagConstraints();
        cStopField.anchor = 17;
        cStopField.gridx = 1;
        cStopField.weightx = 0.0;
        this.stopField = new IntegerWidget(BigInteger.ONE, BigInteger.valueOf(31L));
        this.stopField.addFocusListener(AutoSelectFocusListener.INSTANCE);
        this.stopField.addPropertyChangeListener("VALUE_PROPERTY", listener);
        this.stopField.setColumns(2);
        this.deferedPanel.add((Component)this.stopField, cStopField);
        GridBagConstraints debtLabelConstraints = new GridBagConstraints();
        debtLabelConstraints.anchor = 17;
        debtLabelConstraints.gridx = 2;
        debtLabelConstraints.insets = insets;
        this.debtLabel = new JLabel(LocalizationData.get("ModeDialog.debt"));
        this.deferedPanel.add((Component)this.debtLabel, debtLabelConstraints);
        GridBagConstraints debtFieldConstraints = new GridBagConstraints();
        debtFieldConstraints.gridx = 3;
        debtFieldConstraints.anchor = 17;
        debtFieldConstraints.weightx = 1.0;
        this.debtField = new IntegerWidget(BigInteger.ONE, BigInteger.valueOf(31L));
        this.debtField.addFocusListener(AutoSelectFocusListener.INSTANCE);
        this.debtField.addPropertyChangeListener("VALUE_PROPERTY", listener);
        this.debtField.setColumns(2);
        this.deferedPanel.add((Component)this.debtField, debtFieldConstraints.clone());
        this.deferedPanel.setVisible(false);
        this.emptyPanel = new JPanel();
        this.homogeneizePreferedSize(new JPanel[]{this.emptyPanel, this.relativePanel, this.deferedPanel});
        cCombo.gridy = 2;
        cCombo.gridx = 0;
        cCombo.gridwidth = 0;
        cCombo.fill = 2;
        this.add((Component)this.relativePanel, cCombo.clone());
        this.add((Component)this.deferedPanel, cCombo.clone());
        this.add((Component)this.emptyPanel, cCombo.clone());
        if (checkBookOption) {
            c = new GridBagConstraints();
            c.insets = insets;
            c.gridy = 3;
            c.gridwidth = 0;
            c.anchor = 17;
            this.checkBook = new JCheckBox(LocalizationData.get("ModeDialog.useCheckBook"));
            this.checkBook.setEnabled(false);
            this.add((Component)this.checkBook, c);
        }
    }

    DateStepper getValueDateComputer() {
        if (this.isSelectedBox.isSelected()) {
            int index = this.combo.getSelectedIndex();
            if (index == 0) {
                return DateStepper.IMMEDIATE;
            }
            if (index == 1) {
                return new DayDateStepper(this.relField.getValue().intValue(), null);
            }
            if (index == 2) {
                return new DeferredValueDateComputer(this.stopField.getValue().intValue(), this.debtField.getValue().intValue());
            }
            throw new RuntimeException();
        }
        return null;
    }

    private void homogeneizePreferedSize(JPanel[] panels) {
        int width = 0;
        int height = 0;
        for (int i = 0; i < panels.length; ++i) {
            Dimension d = panels[i].getPreferredSize();
            width = Math.max(width, d.width);
            height = Math.max(height, d.height);
        }
        Dimension d = new Dimension(width, height);
        for (int i = 0; i < panels.length; ++i) {
            panels[i].setPreferredSize(d);
        }
    }

    public boolean isSelected() {
        return this.isSelectedBox.isSelected();
    }

    private void checkValidity() {
        boolean isValid = this.hasValidContent();
        if (this.lastValidity != isValid) {
            this.firePropertyChange(IS_VALID_PROPERTY, this.lastValidity, isValid);
            this.lastValidity = isValid;
        }
    }

    public boolean hasValidContent() {
        if (!this.isSelected()) {
            return true;
        }
        int index = this.combo.getSelectedIndex();
        if (index == 1) {
            return this.relField.getValue() != null;
        }
        if (index == 2) {
            return this.stopField.getValue() != null && this.debtField.getValue() != null;
        }
        return true;
    }

    public void setContent(DateStepper vdc) {
        this.isSelectedBox.setSelected(vdc != null);
        if (vdc != null) {
            if (vdc == DateStepper.IMMEDIATE) {
                this.combo.setSelectedIndex(0);
            } else if (vdc instanceof DayDateStepper) {
                this.combo.setSelectedIndex(1);
                this.relField.setValue(((DayDateStepper)vdc).getStep());
            } else if (vdc instanceof DeferredValueDateComputer) {
                this.combo.setSelectedIndex(2);
                this.stopField.setValue(((DeferredValueDateComputer)vdc).getStopDay());
                this.debtField.setValue(((DeferredValueDateComputer)vdc).getDebtDay());
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean isCheckBookSelected() {
        return this.checkBook != null && this.checkBook.isSelected();
    }

    public void setCheckBookSelected(boolean selected) {
        this.checkBook.setSelected(selected);
    }
}

