/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Window;
import javax.swing.JPanel;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.data.SubTransaction;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.SubTransactionPanel;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;

public class SubTransactionDialog
extends AbstractDialog<GlobalData, SubTransaction> {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private SubTransactionPanel panel;

    public SubTransactionDialog(Window owner, GlobalData data, SubTransaction subtransaction) {
        super(owner, subtransaction == null ? LocalizationData.get("SubTransactionDialog.title.new") : LocalizationData.get("SubTransactionDialog.title.edit"), data);
        if (subtransaction != null) {
            this.panel.setDescription(subtransaction.getDescription());
            this.panel.setAmount(subtransaction.getAmount());
            this.panel.setCategory(subtransaction.getCategory());
        }
    }

    @Override
    protected JPanel createCenterPane() {
        this.panel = new SubTransactionPanel((GlobalData)this.data);
        this.panel.addPropertyChangeListener(new AutoUpdateOkButtonPropertyListener(this));
        return this.panel;
    }

    @Override
    protected SubTransaction buildResult() {
        Double amount = this.panel.getAmount();
        String description = this.panel.getDescription();
        Category category = this.panel.getCategory();
        return new SubTransaction(amount, description, category);
    }

    public SubTransaction getSubTransaction() {
        return (SubTransaction)super.getResult();
    }

    @Override
    protected String getOkDisabledCause() {
        if (this.panel.getDescription().length() == 0) {
            return LocalizationData.get("SubTransactionDialog.empty.desciption");
        }
        if (this.panel.getAmount() == null) {
            return LocalizationData.get("SubTransactionDialog.empty.amount");
        }
        if (this.panel.getAmount() == 0.0) {
            return LocalizationData.get("SubTransactionDialog.null.amount");
        }
        return null;
    }

    public void setPredefined(String[] predefined, int unsortedSize) {
        this.panel.setPredefined(predefined, unsortedSize);
    }

    public void setPredefinedUpdater(SubTransactionPanel.PredefinedDescriptionUpdater updater) {
        this.panel.setUpdater(updater);
    }
}

