/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.export;

import java.io.Serializable;
import java.nio.charset.Charset;
import net.yapbam.gui.dialogs.export.ExportTableModel;
import net.yapbam.util.ArrayUtils;

public class ExporterParameters
implements Serializable {
    private static final long serialVersionUID = 6487527320997875709L;
    private int[] viewIndexesToModel;
    private boolean[] selectedModelColumns;
    private boolean insertHeader;
    private char separator;
    private boolean exportInitialBalance;
    private boolean exportFilteredData;
    private int[] exportedIndexes;

    public ExporterParameters() {
        this(ArrayUtils.buildIntArray(ExportTableModel.COLUMNS.length, 0, 1), ArrayUtils.buildBooleanArray(ExportTableModel.COLUMNS.length, true), true, ';', true, true);
    }

    public ExporterParameters(int[] viewindexesToModel, boolean[] selectedModelColumns, boolean insertHeader, char separator, boolean exportInitialBalance, boolean exportFilteredData) {
        this.viewIndexesToModel = viewindexesToModel;
        this.selectedModelColumns = selectedModelColumns;
        this.insertHeader = insertHeader;
        this.separator = separator;
        this.exportInitialBalance = exportInitialBalance;
        this.exportFilteredData = exportFilteredData;
        int nbSelected = 0;
        for (boolean b : selectedModelColumns) {
            if (!b) continue;
            ++nbSelected;
        }
        int i = 0;
        this.exportedIndexes = new int[nbSelected];
        for (int j = 0; j < viewindexesToModel.length; ++j) {
            if (!selectedModelColumns[viewindexesToModel[j]]) continue;
            this.exportedIndexes[i] = viewindexesToModel[j];
            ++i;
        }
    }

    public int[] getExportedIndexes() {
        return this.exportedIndexes;
    }

    public int[] getViewIndexesToModel() {
        return this.viewIndexesToModel;
    }

    public boolean[] getSelectedModelColumns() {
        return this.selectedModelColumns;
    }

    public boolean isInsertHeader() {
        return this.insertHeader;
    }

    public char getSeparator() {
        return this.separator;
    }

    public boolean isExportInitialBalance() {
        return this.exportInitialBalance;
    }

    public boolean isExportFilteredData() {
        return this.exportFilteredData;
    }

    public void setExportFilteredData(boolean exportFilteredData) {
        this.exportFilteredData = exportFilteredData;
    }

    public Charset getEncoding() {
        return Charset.defaultCharset();
    }
}

