/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.export;

import com.fathzer.soft.ajlib.swing.table.JTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.export.ExportTableModel;
import net.yapbam.gui.dialogs.export.ImportError;
import net.yapbam.gui.util.JTableUtils;

public class ImportErrorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane = null;
    private javax.swing.JTable jTable = null;
    private JLabel jLabel = null;
    private ImportError[] errors;
    private int[] importedFileColumns;

    public ImportErrorPanel() {
        this(new int[0], new ImportError[0]);
    }

    public ImportErrorPanel(int[] importedFileColumns, ImportError[] errors) {
        this.errors = errors;
        this.importedFileColumns = importedFileColumns;
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints1.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
        this.add((Component)this.getJLabel(), gridBagConstraints1);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private javax.swing.JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable(new ImportErrorTableModel());
            this.jTable.getTableHeader().setReorderingAllowed(false);
            this.jTable.setAutoResizeMode(0);
            this.jTable.setIntercellSpacing(new Dimension(4, this.jTable.getIntercellSpacing().height));
            this.jTable.setDefaultRenderer(Object.class, new ObjectRenderer());
            JTableUtils.initColumnSizes(this.jTable, 200);
            this.jTable.setFillsViewportHeight(true);
            Dimension preferredSize = this.getJTable().getPreferredSize();
            preferredSize.width = Math.min(preferredSize.width, 1024);
            preferredSize.height = Math.min(this.jTable.getRowHeight() * 10, 600);
            this.jTable.setPreferredScrollableViewportSize(preferredSize);
        }
        return this.jTable;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
            this.jLabel.setText(LocalizationData.get("ImportDialog.errorMessagemessage"));
        }
        return this.jLabel;
    }

    private final class ImportErrorTableModel
    extends AbstractTableModel {
        private int columnsCount = 1;
        private String[] columnsHeaders;

        public ImportErrorTableModel() {
            int i;
            for (i = 0; i < ImportErrorPanel.this.importedFileColumns.length; ++i) {
                if (ImportErrorPanel.this.importedFileColumns[i] < 0) continue;
                this.columnsCount = Math.max(this.columnsCount, ImportErrorPanel.this.importedFileColumns[i] + 1);
            }
            for (i = 0; i < ImportErrorPanel.this.errors.length; ++i) {
                this.columnsCount = Math.max(this.columnsCount, ImportErrorPanel.this.errors[i].getFields().length);
            }
            ++this.columnsCount;
            this.columnsHeaders = new String[this.columnsCount];
            this.columnsHeaders[0] = LocalizationData.get("ImportDialog.errorMessagelineNumberColumnHeader");
            for (i = 1; i < this.columnsHeaders.length; ++i) {
                this.columnsHeaders[i] = "";
            }
            for (i = 0; i < ImportErrorPanel.this.importedFileColumns.length; ++i) {
                if (ImportErrorPanel.this.importedFileColumns[i] < 0) continue;
                this.columnsHeaders[((ImportErrorPanel)ImportErrorPanel.this).importedFileColumns[i] + 1] = ExportTableModel.COLUMNS[i];
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ImportErrorPanel.this.errors[rowIndex].getLineNumber();
            }
            String[] fields = ImportErrorPanel.this.errors[rowIndex].getFields();
            if (columnIndex > fields.length) {
                return "";
            }
            return fields[columnIndex - 1];
        }

        @Override
        public int getRowCount() {
            return ImportErrorPanel.this.errors.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnsCount;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Integer.class : super.getColumnClass(columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            return this.columnsHeaders[column];
        }
    }

    private final class ObjectRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(javax.swing.JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                column = table.convertColumnIndexToModel(column);
                boolean error = false;
                if (column > 0) {
                    row = table.convertRowIndexToModel(row);
                    error = ImportErrorPanel.this.errors[row].hasError(column - 1);
                }
                this.setBackground(error ? Color.red : table.getBackground());
            }
            return this;
        }
    }
}

