/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.export;

import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.export.ExportTableModel;

public class ImportTableModel
extends AbstractTableModel {
    private boolean[] linked;
    private int[] to;
    private String[] fields = new String[0];

    public ImportTableModel() {
        this.linked = new boolean[ExportTableModel.COLUMNS.length];
        this.to = new int[this.linked.length];
        for (int i = 0; i < this.linked.length; ++i) {
            this.to[i] = -1;
        }
    }

    public int[] getRelations() {
        int[] result = new int[ExportTableModel.COLUMNS.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.linked[i] ? this.to[i] : -1;
        }
        return result;
    }

    public void setRelations(int[] importedColumns) {
        for (int i = 0; i < importedColumns.length; ++i) {
            boolean bl = this.linked[i] = importedColumns[i] >= 0;
            if (importedColumns[i] == -1) continue;
            this.to[i] = importedColumns[i];
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return ExportTableModel.COLUMNS.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return ExportTableModel.COLUMNS[rowIndex];
        }
        if (columnIndex == 1) {
            return this.linked[rowIndex] && this.to[rowIndex] >= 0;
        }
        int index = this.to[rowIndex];
        return index == -1 || !this.linked[rowIndex] ? "-" : (this.fields.length > index ? this.fields[index] : "");
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return LocalizationData.get("ImportDialog.YapbamFields");
        }
        if (column == 1) {
            return LocalizationData.get("ImportDialog.linkedTo");
        }
        return LocalizationData.get("ImportDialog.importedFields");
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            this.linked[rowIndex] = (Boolean)aValue;
        } else if (columnIndex == 2) {
            this.to[rowIndex] = -1;
            for (int i = 0; i < this.fields.length; ++i) {
                if (aValue != this.fields[i]) continue;
                this.to[rowIndex] = i;
                this.linked[rowIndex] = true;
                break;
            }
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 1 ? Boolean.class : super.getColumnClass(columnIndex);
    }

    public void setFields(String[] fields) {
        this.fields = (String[])fields.clone();
        List<String> asList = Arrays.asList(fields);
        for (int i = 0; i < ExportTableModel.COLUMNS.length; ++i) {
            int index = asList.indexOf(ExportTableModel.COLUMNS[i]);
            if (index < 0) continue;
            this.to[i] = index;
            this.linked[i] = true;
        }
        this.fireTableDataChanged();
    }
}

