/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.export;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.charset.Charset;
import net.yapbam.gui.dialogs.export.ExportTableModel;

public class ImporterParameters
implements Serializable {
    private static final long serialVersionUID = 560758261413517776L;
    private char separator;
    private int ignoredLeadingLines;
    private int[] importedFileColumns;
    private char decimalSeparator;

    public ImporterParameters(char columnSeparator, char decimalSeparator, int ignoredLeadingLines, int[] importedFileColumns) {
        if (importedFileColumns.length != ExportTableModel.COLUMNS.length) {
            throw new IllegalArgumentException();
        }
        this.separator = columnSeparator;
        this.decimalSeparator = decimalSeparator;
        this.ignoredLeadingLines = ignoredLeadingLines;
        this.importedFileColumns = importedFileColumns;
    }

    Object readResolve() throws ObjectStreamException {
        if (this.importedFileColumns.length == ExportTableModel.COLUMNS.length) {
            return this;
        }
        if (this.importedFileColumns.length != 9) {
            throw new ObjectStreamException(){
                private static final long serialVersionUID = 1L;
            };
        }
        int[] array = new int[ExportTableModel.COLUMNS.length];
        System.arraycopy(this.importedFileColumns, 0, array, 0, 3);
        array[3] = -1;
        System.arraycopy(this.importedFileColumns, 3, array, 4, array.length - 4);
        this.importedFileColumns = array;
        return this;
    }

    public char getColumnSeparator() {
        return this.separator;
    }

    public void setColumnSeparator(char columnSeparator) {
        this.separator = columnSeparator;
    }

    public int getIgnoredLeadingLines() {
        return this.ignoredLeadingLines;
    }

    public void setIgnoredLeadingLines(int ignoredLeadingLines) {
        this.ignoredLeadingLines = ignoredLeadingLines;
    }

    public int[] getImportedFileColumns() {
        return this.importedFileColumns;
    }

    public void setImportedFilecolumns(int[] importedFilecolumns) {
        this.importedFileColumns = importedFilecolumns;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public Charset getEncoding() {
        return Charset.defaultCharset();
    }
}

