/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.periodicaltransaction;

import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.gui.dialogs.periodicaltransaction.ExtendedPeriodicalTransaction;
import net.yapbam.gui.dialogs.periodicaltransaction.GeneratedTransaction;

public class Generator {
    private ExtendedPeriodicalTransaction[] pTransactions;
    private List<GeneratedTransaction> transactions;
    private Date date;

    public Generator(GlobalData data) {
        this.pTransactions = new ExtendedPeriodicalTransaction[data.getPeriodicalTransactionsNumber()];
        for (int i = 0; i < this.pTransactions.length; ++i) {
            this.pTransactions[i] = new ExtendedPeriodicalTransaction(data.getPeriodicalTransaction(i));
        }
        this.transactions = new ArrayList<GeneratedTransaction>();
        this.date = null;
    }

    public int getNbTransactions() {
        return this.transactions.size();
    }

    public Transaction getTransaction(int index) {
        return this.transactions.get(index).getTransaction();
    }

    public boolean isCancelled(int index) {
        return this.transactions.get(index).isCancelled();
    }

    public boolean isPostponed(int index) {
        return this.transactions.get(index).isPostponed();
    }

    public Date getDate() {
        return this.date;
    }

    public boolean setDate(Date date) {
        if (NullUtils.areEquals(date, this.date)) {
            return false;
        }
        this.date = date;
        this.refreshTransactions();
        return true;
    }

    private void refreshTransactions() {
        this.transactions.clear();
        if (this.date != null) {
            for (int i = 0; i < this.pTransactions.length; ++i) {
                this.transactions.addAll(this.pTransactions[i].getTransactions(this.date));
            }
        }
    }

    public void setTransaction(int index, Transaction transaction) {
        this.transactions.get(index).setTransaction(transaction);
    }

    public void setCancelled(int index, boolean cancelled) {
        this.transactions.get(index).setCancelled(cancelled);
    }

    public void setPostponed(int index, boolean postponed) {
        GeneratedTransaction t = this.transactions.get(index);
        Date tDate = t.getDate();
        if (postponed) {
            t.getSource().setPosponedDate(tDate);
        } else {
            t.getSource().setPosponedDate(null);
        }
        this.refreshTransactions();
    }

    public Date getPostponedDate(int indexPeriodical) {
        return this.pTransactions[indexPeriodical].getPosponedDate();
    }
}

