/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.periodicaltransaction;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.data.PeriodicalTransaction;
import net.yapbam.data.SubTransaction;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.AbstractTransactionDialog;
import net.yapbam.gui.dialogs.EditAccountDialog;
import net.yapbam.gui.dialogs.GenerationPanel;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;

public class PeriodicalTransactionDialog
extends AbstractTransactionDialog<PeriodicalTransaction> {
    private static final long serialVersionUID = 1L;
    private GenerationPanel generationPanel;

    public static PeriodicalTransaction open(GlobalData data, Window frame, PeriodicalTransaction transaction, boolean edit) {
        if (data.getAccountsNumber() == 0) {
            EditAccountDialog.open(data, frame, LocalizationData.get("TransactionDialog.needAccount"));
            if (data.getAccountsNumber() == 0) {
                return null;
            }
        }
        PeriodicalTransactionDialog dialog = new PeriodicalTransactionDialog(frame, data, transaction, edit);
        dialog.setVisible(true);
        PeriodicalTransaction newTransaction = dialog.getTransaction();
        if (newTransaction != null) {
            if (transaction != null) {
                data.remove(transaction);
            }
            data.add(newTransaction);
        }
        return newTransaction;
    }

    private PeriodicalTransactionDialog(Window owner, GlobalData data, PeriodicalTransaction transaction, boolean edit) {
        super(owner, edit ? LocalizationData.get("PeriodicalTransactionDialog.title.edit") : LocalizationData.get("PeriodicalTransactionDialog.title.new"), data, transaction);
    }

    @Override
    protected void setContent(AbstractTransaction transaction) {
        super.setContent(transaction);
        PeriodicalTransaction t = (PeriodicalTransaction)transaction;
        this.generationPanel.setActivated(t.isEnabled());
        this.generationPanel.setNextDate(t.getNextDate());
        this.generationPanel.setDateStepper(t.getNextDateBuilder());
    }

    @Override
    protected JPanel createCenterPane() {
        JPanel center = new JPanel(new BorderLayout());
        JPanel transactionPane = super.createCenterPane();
        transactionPane.setBorder(BorderFactory.createTitledBorder(LocalizationData.get("PeriodicalTransactionDialog.transactionBorderTitle")));
        center.add((Component)transactionPane, "Center");
        center.add((Component)this.buildPeriodicalPanel(), "North");
        return center;
    }

    private JComponent buildPeriodicalPanel() {
        this.generationPanel = new GenerationPanel();
        this.generationPanel.setBorder(BorderFactory.createTitledBorder(LocalizationData.get("PeriodicalTransactionDialog.generationBorderTitle")));
        this.generationPanel.addPropertyChangeListener(new AutoUpdateOkButtonPropertyListener(this));
        return this.generationPanel;
    }

    @Override
    protected PeriodicalTransaction buildResult() {
        double amount = this.getAmount();
        ArrayList<SubTransaction> subTransactions = new ArrayList<SubTransaction>();
        for (int i = 0; i < this.subtransactionsPanel.getSubtransactionsCount(); ++i) {
            subTransactions.add(this.subtransactionsPanel.getSubtransaction(i));
        }
        return new PeriodicalTransaction(this.description.getText().trim(), this.comment.getText().trim(), amount, this.getAccount(), this.getCurrentMode(), (Category)this.categories.get(), subTransactions, this.generationPanel.getNextDate(), this.generationPanel.isActivated(), this.generationPanel.getDateStepper());
    }

    @Override
    protected void buildStatementFields(JPanel centerPane, FocusListener focusListener, GridBagConstraints c) {
    }

    @Override
    protected void buildNumberField(JPanel centerPane, FocusListener focusListener, GridBagConstraints c) {
    }

    @Override
    protected void buildDateField(JPanel centerPane, FocusListener focusListener, GridBagConstraints c) {
    }

    @Override
    public PeriodicalTransaction getTransaction() {
        return (PeriodicalTransaction)super.getResult();
    }

    @Override
    protected String getOkDisabledCause() {
        String disabledCause = super.getOkDisabledCause();
        if (disabledCause != null || this.generationPanel == null) {
            return disabledCause;
        }
        if (!this.generationPanel.getNextDateIsValid()) {
            return LocalizationData.get("PeriodicalTransactionDialog.error.nextDate");
        }
        Date nextDate = this.generationPanel.getNextDate();
        if (nextDate == null && this.generationPanel.isActivated()) {
            return LocalizationData.get("PeriodicalTransactionDialog.error.nextDate");
        }
        DateStepper dateStepper = this.generationPanel.getDateStepper();
        if (dateStepper == null) {
            return LocalizationData.get("PeriodicalTransactionDialog.error.dateStepper");
        }
        if (!this.generationPanel.getLastDateIsValid()) {
            return LocalizationData.get("PeriodicalTransactionDialog.error.endDate");
        }
        if (dateStepper.getLastDate() != null && nextDate != null && dateStepper.getLastDate().compareTo(nextDate) < 0) {
            return LocalizationData.get("PeriodicalTransactionDialog.error.nextDateAfterEnd");
        }
        return null;
    }
}

