/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.preferences;

import com.fathzer.jlocal.Formatter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.preferences.PreferencePanel;

public class LocalizationPanel
extends PreferencePanel {
    private static final long serialVersionUID = 1L;
    private static final Locale[] LANGUAGES = new Locale[]{new Locale("ar"), Locale.GERMAN, Locale.ENGLISH, new Locale("es"), Locale.FRENCH, new Locale("el"), new Locale("nl"), new Locale("pt"), new Locale("tr"), Locale.TRADITIONAL_CHINESE, new Locale("it"), new Locale("pl"), new Locale("ru"), new Locale("hu"), new Locale("ja")};
    private static final String[] LANGUAGES_ADDITIONNAL_WORDING = new String[]{"", "", "", "", "", "", "", "", "", "&#23616;&#37096;", "parziale", "cz&#281;&#347;ciowy", "&#1095;&#1072;&#1089;&#1090;&#1080;&#1095;&#1085;&#1099;&#1081;", "r\u00e9szleges", "&#x90E8;&#x5206;&#x7684;&#x306A;"};
    private JPanel countryPanel = null;
    private JPanel languagePanel = null;
    private JRadioButton defaultCButton = null;
    private JRadioButton customButton = null;
    private JScrollPane jScrollPane = null;
    private JList<String> jList = null;
    private boolean jListIsAdjusting = false;
    private JRadioButton defaultLButton;
    private JButton revertButton;
    private ItemListener basicItemListener;
    private Map<String, String> displayCountrytoCode;
    private JCheckBox translatorButton;
    private Map<Locale, JRadioButton> lngButtons = new HashMap<Locale, JRadioButton>();

    public LocalizationPanel() {
        this.basicItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LocalizationPanel.this.checkSomethingChanged();
                }
            }
        };
        this.initialize();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcCountryPanel = new GridBagConstraints();
        gbcCountryPanel.gridheight = 2;
        gbcCountryPanel.weighty = 1.0;
        gbcCountryPanel.anchor = 18;
        gbcCountryPanel.fill = 3;
        gbcCountryPanel.insets = new Insets(0, 0, 5, 5);
        gbcCountryPanel.gridx = 0;
        gbcCountryPanel.gridy = 0;
        this.add((Component)this.getCountryPanel(), gbcCountryPanel);
        GridBagConstraints gbcLanguagePanel = new GridBagConstraints();
        gbcLanguagePanel.anchor = 18;
        gbcLanguagePanel.weightx = 1.0;
        gbcLanguagePanel.fill = 2;
        gbcLanguagePanel.insets = new Insets(0, 0, 5, 0);
        gbcLanguagePanel.gridx = 1;
        gbcLanguagePanel.gridy = 0;
        this.add((Component)this.getLanguagePanel(), gbcLanguagePanel);
        GridBagConstraints gbcRevertButton = new GridBagConstraints();
        gbcRevertButton.gridx = 1;
        gbcRevertButton.gridy = 1;
        this.add((Component)this.getRevertButton(), gbcRevertButton);
        this.reset();
    }

    private void reset() {
        Locale locale = Preferences.INSTANCE.getLocale();
        boolean defaultCountry = Preferences.INSTANCE.isDefaultCountry();
        if (defaultCountry) {
            this.defaultCButton.setSelected(defaultCountry);
        } else {
            this.jList.setSelectedValue(locale.getDisplayCountry(locale), true);
        }
        boolean defaultLanguage = Preferences.INSTANCE.isDefaultLanguage();
        if (defaultLanguage) {
            this.defaultLButton.setSelected(true);
        } else {
            for (Locale lang : LANGUAGES) {
                if (!locale.getLanguage().equals(lang.getLanguage())) continue;
                this.getLngButton(lang).setSelected(true);
                break;
            }
        }
        if (Preferences.INSTANCE.isExpertMode()) {
            this.getTranslatorButton().setSelected(Preferences.INSTANCE.isTranslatorMode());
        }
    }

    private JPanel getCountryPanel() {
        if (this.countryPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            this.countryPanel = new JPanel();
            this.countryPanel.setLayout(new GridBagLayout());
            this.countryPanel.setBorder(BorderFactory.createTitledBorder(null, LocalizationData.get("PreferencesDialog.Localization.country"), 0, 0));
            this.countryPanel.add((Component)this.getDefaultCButton(), gridBagConstraints);
            this.countryPanel.add((Component)this.getCustomButton(), gridBagConstraints1);
            ButtonGroup group = new ButtonGroup();
            group.add(this.getDefaultCButton());
            group.add(this.getCustomButton());
            this.countryPanel.add((Component)this.getJScrollPane(), gridBagConstraints2);
            group = new ButtonGroup();
            group.add(this.getDefaultLButton());
            for (int i = 0; i < LANGUAGES.length; ++i) {
                JRadioButton button = this.getLngButton(LANGUAGES[i]);
                if (!LANGUAGES_ADDITIONNAL_WORDING[i].isEmpty()) {
                    button.setText("<html>" + button.getText() + " (" + LANGUAGES_ADDITIONNAL_WORDING[i] + ")</html>");
                }
                group.add(button);
            }
        }
        return this.countryPanel;
    }

    private GridBagConstraints getLanguageGBC(int index) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = index;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        return gridBagConstraints;
    }

    private JPanel getLanguagePanel() {
        if (this.languagePanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints6.anchor = 17;
            this.languagePanel = new JPanel();
            this.languagePanel.setLayout(new GridBagLayout());
            this.languagePanel.setBorder(BorderFactory.createTitledBorder(null, LocalizationData.get("PreferencesDialog.Localization.language"), 0, 0));
            this.languagePanel.add((Component)this.getTranslatorButton(), gridBagConstraints6);
            int index = 1;
            this.languagePanel.add((Component)this.getDefaultLButton(), this.getLanguageGBC(index++));
            for (Locale locale : LANGUAGES) {
                this.languagePanel.add((Component)this.getLngButton(locale), this.getLanguageGBC(index++));
            }
        }
        return this.languagePanel;
    }

    private JRadioButton getDefaultCButton() {
        if (this.defaultCButton == null) {
            this.defaultCButton = new JRadioButton();
            String defaultDisplayCountry = LocalizationData.SYS_LOCALE.getDisplayCountry(Preferences.INSTANCE.getLocale());
            String tip = Formatter.format(LocalizationData.get("PreferencesDialog.Localization.defaultCountry.toolTip"), defaultDisplayCountry);
            this.defaultCButton.setToolTipText(tip);
            this.defaultCButton.setText(Formatter.format(LocalizationData.get("PreferencesDialog.Localization.defaultCountry"), defaultDisplayCountry));
            this.defaultCButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LocalizationPanel.this.jList.clearSelection();
                        LocalizationPanel.this.checkSomethingChanged();
                    }
                }
            });
        }
        return this.defaultCButton;
    }

    private JRadioButton getCustomButton() {
        if (this.customButton == null) {
            this.customButton = new JRadioButton();
            this.customButton.setText(LocalizationData.get("PreferencesDialog.Localization.customCountry"));
            this.customButton.setToolTipText(LocalizationData.get("PreferencesDialog.Localization.customCountry.tooTip"));
            this.customButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (!LocalizationPanel.this.jListIsAdjusting && LocalizationPanel.this.jList.getSelectedIndex() < 0) {
                            LocalizationPanel.this.jList.setSelectedValue(LocalizationData.SYS_LOCALE.getDisplayCountry(Preferences.INSTANCE.getLocale()), true);
                        }
                        LocalizationPanel.this.checkSomethingChanged();
                    }
                }
            });
        }
        return this.customButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JList<String> getJList() {
        if (this.jList == null) {
            String[] countryCodes = Locale.getISOCountries();
            Object[] countries = new String[countryCodes.length];
            this.displayCountrytoCode = new HashMap<String, String>();
            for (int i = 0; i < countryCodes.length; ++i) {
                countries[i] = new Locale(Preferences.INSTANCE.getLocale().getLanguage(), countryCodes[i]).getDisplayCountry(Preferences.INSTANCE.getLocale());
                this.displayCountrytoCode.put((String)countries[i], countryCodes[i]);
            }
            Arrays.sort(countries);
            this.jList = new JList<Object>(countries);
            this.jList.setToolTipText(LocalizationData.get("PreferencesDialog.Localization.countryList.tooltip"));
            this.jList.setSelectionMode(0);
            this.jList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        if (LocalizationPanel.this.jList.getSelectedIndex() > 0) {
                            LocalizationPanel.this.jListIsAdjusting = true;
                            LocalizationPanel.this.customButton.setSelected(true);
                            LocalizationPanel.this.jListIsAdjusting = false;
                        }
                        LocalizationPanel.this.checkSomethingChanged();
                    }
                }
            });
        }
        return this.jList;
    }

    void checkSomethingChanged() {
        this.revertButton.setEnabled(this.isChanged());
    }

    public boolean isChanged() {
        Locale loc = Preferences.INSTANCE.getLocale();
        boolean change = !loc.equals(this.getBuiltLocale()) || Preferences.INSTANCE.isDefaultCountry() != this.isDefaultCountry() || Preferences.INSTANCE.isDefaultLanguage() != this.isDefaultLanguage() || Preferences.INSTANCE.isTranslatorMode() != this.isTranslatorMode();
        return change;
    }

    public Locale getBuiltLocale() {
        String country = this.getDefaultCButton().isSelected() ? LocalizationData.SYS_LOCALE.getCountry() : this.displayCountrytoCode.get(this.jList.getSelectedValue());
        String lang = LocalizationData.SYS_LOCALE.getLanguage();
        for (Locale locale : LANGUAGES) {
            if (!this.getLngButton(locale).isSelected()) continue;
            lang = locale.getLanguage();
            break;
        }
        return new Locale(lang, country);
    }

    public boolean isDefaultCountry() {
        return this.getDefaultCButton().isSelected();
    }

    public boolean isDefaultLanguage() {
        return this.getDefaultLButton().isSelected();
    }

    public boolean isTranslatorMode() {
        return this.getTranslatorButton().isSelected();
    }

    private JRadioButton getDefaultLButton() {
        if (this.defaultLButton == null) {
            this.defaultLButton = new JRadioButton();
            this.defaultLButton.setText(LocalizationData.get("PreferencesDialog.Localization.defaultLanguage"));
            this.defaultLButton.setToolTipText(LocalizationData.get("PreferencesDialog.Localization.defaultLanguage.toolTip"));
            this.defaultLButton.addItemListener(this.basicItemListener);
        }
        return this.defaultLButton;
    }

    private JButton getRevertButton() {
        if (this.revertButton == null) {
            this.revertButton = new JButton();
            this.revertButton.setText(LocalizationData.get("PreferencesDialog.Localization.revert"));
            this.revertButton.setToolTipText(LocalizationData.get("PreferencesDialog.Localization.revert.toolTip"));
            this.revertButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LocalizationPanel.this.reset();
                }
            });
        }
        return this.revertButton;
    }

    @Override
    public String getTitle() {
        return LocalizationData.get("PreferencesDialog.Localization.title");
    }

    @Override
    public String getToolTip() {
        return LocalizationData.get("PreferencesDialog.Localization.toolTip");
    }

    @Override
    public boolean updatePreferences() {
        boolean needIHMRefresh = false;
        if (this.isChanged()) {
            Locale builtLocale = this.getBuiltLocale();
            needIHMRefresh = !builtLocale.equals(Preferences.INSTANCE.getLocale()) || this.isTranslatorMode() != Preferences.INSTANCE.isTranslatorMode();
            Preferences.INSTANCE.setLocale(builtLocale, this.isDefaultCountry(), this.isDefaultLanguage());
            Preferences.INSTANCE.setTranslatorMode(this.isTranslatorMode());
            if (needIHMRefresh) {
                LocalizationData.reset();
            }
        }
        return needIHMRefresh;
    }

    private JCheckBox getTranslatorButton() {
        if (this.translatorButton == null) {
            this.translatorButton = new JCheckBox(LocalizationData.get("PreferencesDialog.translatorMode"));
            this.translatorButton.setToolTipText(LocalizationData.get("PreferencesDialog.translatorMode.tooltip"));
            this.translatorButton.setSelected(Preferences.safeIsTranslatorMode());
            this.translatorButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LocalizationPanel.this.checkSomethingChanged();
                }
            });
            this.translatorButton.setVisible(false);
        }
        return this.translatorButton;
    }

    @Override
    protected void setExpertMode(boolean expertMode) {
        this.getTranslatorButton().setVisible(expertMode || Preferences.safeIsTranslatorMode());
    }

    private JRadioButton getLngButton(Locale locale) {
        if (!this.lngButtons.containsKey(locale)) {
            JRadioButton btn = new JRadioButton(locale.getDisplayLanguage(locale));
            btn.addItemListener(this.basicItemListener);
            this.lngButtons.put(locale, btn);
        }
        return this.lngButtons.get(locale);
    }
}

