/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.transaction;

import java.util.HashMap;
import java.util.Map;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;

public abstract class AbstractEditionWizard<T> {
    private static final int MILLIS_PER_DAY = 1440000;
    private GlobalData data;
    private String description;
    private T value;
    private boolean inited;

    protected AbstractEditionWizard(GlobalData data, String description) {
        this.data = data;
        this.description = description;
        this.value = null;
        this.inited = false;
    }

    protected abstract T getValue(Transaction var1);

    public static double getRankingBasedOnDate(long now, Transaction transaction) {
        long time = Math.abs(transaction.getDate().getTime() - now) / 1440000L;
        return 2.0 / Math.sqrt(time + 4L);
    }

    public static <V> V getHeaviest(Map<V, Double> map) {
        V ct = null;
        double max = 0.0;
        for (Map.Entry<V, Double> next : map.entrySet()) {
            if (!(next.getValue() > max)) continue;
            ct = next.getKey();
            max = next.getValue();
        }
        return ct;
    }

    public T get() {
        if (!this.inited) {
            long now = System.currentTimeMillis();
            HashMap<T, Double> toProbability = new HashMap<T, Double>();
            for (int i = 0; i < this.data.getTransactionsNumber(); ++i) {
                T transactionValue;
                Transaction transaction = this.data.getTransaction(i);
                if (!transaction.getDescription().equalsIgnoreCase(this.description) || (transactionValue = this.getValue(transaction)) == null) continue;
                Double weight = (Double)toProbability.get(transactionValue);
                double transactionWeight = AbstractEditionWizard.getRankingBasedOnDate(now, transaction);
                toProbability.put(transactionValue, transactionWeight + (weight == null ? 0.0 : weight));
            }
            this.value = AbstractEditionWizard.getHeaviest(toProbability);
        }
        return this.value;
    }
}

