/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.update;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.utilities.FileUtils;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.MainFrame;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.update.LongTaskDialog;
import net.yapbam.gui.dialogs.update.Messages;
import net.yapbam.gui.dialogs.update.WaitPanel;
import net.yapbam.update.UpdateInformation;
import net.yapbam.util.Portable;
import net.yapbam.util.SecureDownloader;

public class InstallUpdateDialog
extends LongTaskDialog<UpdateInformation, Void> {
    private static final long serialVersionUID = 1L;
    private WaitPanel waitPanel;
    private boolean auto;

    public InstallUpdateDialog(Window owner, boolean auto, UpdateInformation data) {
        super(owner, LocalizationData.get("Update.Downloading.title"), data);
        this.auto = auto;
        if (auto) {
            this.setDelay(Long.MAX_VALUE);
        }
    }

    @Override
    protected SwingWorker<?, ?> getWorker() {
        return new DownloadSwingWorker(this.getOwner());
    }

    @Override
    protected JPanel createCenterPane() {
        this.waitPanel = new WaitPanel();
        this.waitPanel.setMessage(Formatter.format(LocalizationData.get("Update.Downloading.message"), ((UpdateInformation)this.data).getLastestRelease().toString()));
        this.waitPanel.setIndeterminate(false);
        this.waitPanel.setMaximum(100);
        return this.waitPanel;
    }

    @Override
    protected Void buildResult() {
        return null;
    }

    @Override
    protected String getOkDisabledCause() {
        return null;
    }

    class DownloadSwingWorker
    extends SwingWorker<Boolean, Integer> {
        private Window owner;
        private int lastProgress;

        DownloadSwingWorker(Window owner) {
            this.owner = owner;
            this.lastProgress = 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected Boolean doInBackground() throws Exception {
            while (true) {
                try {
                    String zipChck;
                    File destinationFolder = Portable.getUpdateFileDirectory();
                    FileUtils.deleteDirectory(destinationFolder);
                    destinationFolder.mkdirs();
                    boolean ok = false;
                    String errorMessage = null;
                    MyDownloader sd = new MyDownloader(Preferences.INSTANCE.getHttpProxy());
                    SecureDownloader.DownloadInfo info = sd.download(((UpdateInformation)InstallUpdateDialog.this.data).getAutoUpdateURL(), new File(destinationFolder, "update.zip"));
                    String string = zipChck = info == null ? null : info.getCheckSum();
                    if (NullUtils.areEquals(zipChck, ((UpdateInformation)InstallUpdateDialog.this.data).getAutoUpdateCheckSum())) {
                        SecureDownloader.DownloadInfo jarInfo = sd.download(((UpdateInformation)InstallUpdateDialog.this.data).getAutoUpdaterURL(), new File(destinationFolder, "updater.jar"));
                        String updaterChck = jarInfo == null ? null : jarInfo.getCheckSum();
                        ok = NullUtils.areEquals(updaterChck, ((UpdateInformation)InstallUpdateDialog.this.data).getAutoUpdaterCheckSum());
                        if (!ok) {
                            errorMessage = "Checksum of " + ((UpdateInformation)InstallUpdateDialog.this.data).getAutoUpdaterURL() + Messages.getString("InstallUpdateDialog.5") + zipChck + Messages.getString("InstallUpdateDialog.6") + ((UpdateInformation)InstallUpdateDialog.this.data).getAutoUpdaterCheckSum() + Messages.getString("InstallUpdateDialog.7");
                        }
                    } else {
                        errorMessage = Messages.getString("InstallUpdateDialog.8") + ((UpdateInformation)InstallUpdateDialog.this.data).getAutoUpdateURL() + Messages.getString("InstallUpdateDialog.9") + zipChck + Messages.getString("InstallUpdateDialog.10") + ((UpdateInformation)InstallUpdateDialog.this.data).getAutoUpdateCheckSum() + Messages.getString("InstallUpdateDialog.11");
                    }
                    if (this.isCancelled() || !ok) {
                        FileUtils.deleteDirectory(destinationFolder);
                    }
                    if (this.isCancelled()) {
                        return null;
                    }
                    if (ok) return Boolean.TRUE;
                    throw new IOException(errorMessage);
                }
                catch (Exception e) {
                    if (InstallUpdateDialog.this.auto) continue;
                    DoShowDialog doShowDialog = new DoShowDialog();
                    SwingUtilities.invokeAndWait(doShowDialog);
                    if (!doShowDialog.proceedConfirmed) return null;
                    continue;
                }
                break;
            }
        }

        @Override
        public void done() {
            InstallUpdateDialog.this.setVisible(false);
            try {
                if (this.get() != null && ((Boolean)this.get()).booleanValue()) {
                    MainFrame.updater = this.getUpdaterFile();
                    String message = Formatter.format(LocalizationData.get(Messages.getString("InstallUpdateDialog.12")), ((UpdateInformation)InstallUpdateDialog.this.data).getLastestRelease().toString());
                    Object[] options = new Object[]{LocalizationData.get("GenericButton.close"), LocalizationData.get("Update.Downloaded.quitNow")};
                    int choice = JOptionPane.showOptionDialog(this.owner, message, LocalizationData.get("Update.Downloaded.title"), 0, 1, null, options, options[0]);
                    if (choice == 1) {
                        for (Window window : this.owner.getOwnedWindows()) {
                            window.dispatchEvent(new WindowEvent(window, 201));
                        }
                        this.owner.dispatchEvent(new WindowEvent(this.owner, 201));
                    }
                }
            }
            catch (CancellationException message) {
            }
            catch (InterruptedException message) {
            }
            catch (ExecutionException e) {
                ErrorManager.INSTANCE.log(this.owner, e);
            }
        }

        private File getUpdaterFile() {
            return new File(Portable.getUpdateFileDirectory(), "updater.jar");
        }

        @Override
        protected void process(List<Integer> chunks) {
            Integer value = chunks.get(chunks.size() - 1);
            InstallUpdateDialog.this.waitPanel.setValue(value);
        }

        class DoShowDialog
        implements Runnable {
            boolean proceedConfirmed;

            DoShowDialog() {
            }

            @Override
            public void run() {
                Object[] options = new Object[]{LocalizationData.get("GenericButton.cancel"), LocalizationData.get("Update.DownloadFailed.retry")};
                int n = JOptionPane.showOptionDialog(DownloadSwingWorker.this.owner, LocalizationData.get("Update.DownloadFailed.message"), LocalizationData.get("Update.DownloadFailed.title"), 0, 0, null, options, options[1]);
                this.proceedConfirmed = n == 1;
            }
        }

        private class MyDownloader
        extends SecureDownloader {
            MyDownloader(Proxy proxy) {
                super(proxy);
            }

            @Override
            protected void progress(long downloadedSize) {
                if (DownloadSwingWorker.this.isCancelled()) {
                    this.cancel();
                } else {
                    int percent = (int)(downloadedSize * 100L / (((UpdateInformation)InstallUpdateDialog.this.data).getAutoUpdateSize() + ((UpdateInformation)InstallUpdateDialog.this.data).getAutoUpdaterSize()));
                    if (percent != DownloadSwingWorker.this.lastProgress) {
                        DownloadSwingWorker.this.publish(new Integer[]{percent});
                        DownloadSwingWorker.this.lastProgress = percent;
                    }
                }
            }
        }
    }
}

