/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.filter;

import com.fathzer.soft.ajlib.swing.widget.date.DateWidget;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.filter.ConsistencyCheckedPanel;
import net.yapbam.gui.widget.AutoSelectFocusListener;

public class DateFilterPanel
extends ConsistencyCheckedPanel {
    public static final Wordings TRANSACTION_DATE = new Wordings(LocalizationData.get("Transaction.date"), LocalizationData.get("CustomFilterPanel.date.all"), LocalizationData.get("CustomFilterPanel.date.all.toolTip"), LocalizationData.get("CustomFilterPanel.date.equals"), LocalizationData.get("CustomFilterPanel.date.equals.toolTip"), LocalizationData.get("CustomFilterPanel.date.between"), LocalizationData.get("CustomFilterPanel.date.between.toolTip"), LocalizationData.get("CustomFilterPanel.date.from.toolTip"), LocalizationData.get("CustomFilterPanel.date.to.toolTip"), LocalizationData.get("CustomFilterPanel.date.to"), LocalizationData.get("CustomFilterPanel.error.dateFrom"), LocalizationData.get("CustomFilterPanel.error.date.to"), LocalizationData.get("CustomFilterPanel.error.dateFromHigherThanTo"));
    public static final Wordings VALUE_DATE = new Wordings(LocalizationData.get("Transaction.valueDate"), LocalizationData.get("CustomFilterPanel.valueDate.all"), LocalizationData.get("CustomFilterPanel.valueDate.all.toolTip"), LocalizationData.get("CustomFilterPanel.valueDate.equals"), LocalizationData.get("CustomFilterPanel.valueDate.equals.toolTip"), LocalizationData.get("CustomFilterPanel.valueDate.between"), LocalizationData.get("CustomFilterPanel.valueDate.between.toolTip"), LocalizationData.get("CustomFilterPanel.valueDate.from.toolTip"), LocalizationData.get("CustomFilterPanel.valueDate.to.toolTip"), LocalizationData.get("CustomFilterPanel.valueDate.to"), LocalizationData.get("CustomFilterPanel.error.valueDateFrom"), LocalizationData.get("CustomFilterPanel.error.valueDateTo"), LocalizationData.get("CustomFilterPanel.error.valueDateFromHigherThanTo"));
    private static final long serialVersionUID = 1L;
    private JRadioButton dateAll;
    private JRadioButton dateEquals;
    private JRadioButton dateBetween;
    private DateWidget dateFrom;
    private DateWidget dateTo;
    private Wordings wordings;

    public DateFilterPanel(Wordings wordings) {
        this.wordings = wordings;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, wordings.title, 0, 0));
        GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
        gridBagConstraints25.gridx = 3;
        gridBagConstraints25.gridheight = 3;
        gridBagConstraints25.weightx = 1.0;
        gridBagConstraints25.fill = 2;
        gridBagConstraints25.gridy = 0;
        GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
        gridBagConstraints24.gridx = 2;
        gridBagConstraints24.gridheight = 3;
        gridBagConstraints24.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints24.gridy = 0;
        JLabel jLabel = new JLabel(wordings.to);
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.gridx = 1;
        gridBagConstraints23.gridheight = 3;
        gridBagConstraints23.weightx = 1.0;
        gridBagConstraints23.fill = 2;
        gridBagConstraints23.gridy = 0;
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.gridx = 0;
        gridBagConstraints22.anchor = 17;
        gridBagConstraints22.gridy = 2;
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.gridx = 0;
        gridBagConstraints20.anchor = 17;
        gridBagConstraints20.gridy = 1;
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.gridx = 0;
        gridBagConstraints19.anchor = 17;
        gridBagConstraints19.gridy = 0;
        this.add((Component)this.getDateAll(), gridBagConstraints19);
        this.add((Component)this.getDateEquals(), gridBagConstraints20);
        this.add((Component)this.getDateBetween(), gridBagConstraints22);
        this.add((Component)this.getDateFromField(), gridBagConstraints23);
        this.add((Component)jLabel, gridBagConstraints24);
        this.add((Component)this.getDateToField(), gridBagConstraints25);
        ButtonGroup group = new ButtonGroup();
        group.add(this.getDateAll());
        group.add(this.getDateEquals());
        group.add(this.getDateBetween());
    }

    private JRadioButton getDateAll() {
        if (this.dateAll == null) {
            this.dateAll = new JRadioButton();
            this.dateAll.setText(this.wordings.all);
            this.dateAll.setToolTipText(this.wordings.allTooltip);
            this.dateAll.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (DateFilterPanel.this.dateAll.isSelected()) {
                        DateFilterPanel.this.getDateFromField().setDate(null);
                        DateFilterPanel.this.getDateFromField().setEnabled(false);
                        DateFilterPanel.this.getDateToField().setDate(null);
                        DateFilterPanel.this.getDateToField().setEnabled(false);
                    }
                }
            });
        }
        return this.dateAll;
    }

    private JRadioButton getDateEquals() {
        if (this.dateEquals == null) {
            this.dateEquals = new JRadioButton();
            this.dateEquals.setText(this.wordings.equals);
            this.dateEquals.setToolTipText(this.wordings.equalsTooltip);
            this.dateEquals.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (DateFilterPanel.this.dateEquals.isSelected()) {
                        DateFilterPanel.this.getDateFromField().setEnabled(true);
                        DateFilterPanel.this.getDateToField().setEnabled(false);
                        DateFilterPanel.this.getDateToField().setDate(DateFilterPanel.this.getDateFromField().getDate());
                    }
                }
            });
        }
        return this.dateEquals;
    }

    private JRadioButton getDateBetween() {
        if (this.dateBetween == null) {
            this.dateBetween = new JRadioButton();
            this.dateBetween.setText(this.wordings.between);
            this.dateBetween.setToolTipText(this.wordings.betweenTooltip);
            this.dateBetween.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (DateFilterPanel.this.dateBetween.isSelected()) {
                        DateFilterPanel.this.getDateFromField().setEnabled(true);
                        DateFilterPanel.this.getDateToField().setEnabled(true);
                    }
                }
            });
        }
        return this.dateBetween;
    }

    private DateWidget getDateFromField() {
        if (this.dateFrom == null) {
            this.dateFrom = new DateWidget();
            this.dateFrom.setToolTipText(this.wordings.fromTooltip);
            this.dateFrom.getDateField().addFocusListener(AutoSelectFocusListener.INSTANCE);
            this.dateFrom.addPropertyChangeListener("date", this.consistencyChecker);
            this.dateFrom.addPropertyChangeListener("contentValid", this.consistencyChecker);
        }
        return this.dateFrom;
    }

    private DateWidget getDateToField() {
        if (this.dateTo == null) {
            this.dateTo = new DateWidget();
            this.dateTo.setToolTipText(this.wordings.toTooltip);
            this.dateTo.getDateField().addFocusListener(AutoSelectFocusListener.INSTANCE);
            this.dateTo.addPropertyChangeListener("date", this.consistencyChecker);
            this.dateTo.addPropertyChangeListener("contentValid", this.consistencyChecker);
        }
        return this.dateTo;
    }

    @Override
    protected String computeInconsistencyCause() {
        if (!this.getDateFromField().isContentValid()) {
            return this.wordings.errorFrom;
        }
        if (!this.getDateToField().isContentValid()) {
            return this.wordings.errorTo;
        }
        if (this.getDateFromField().getDate() != null && this.getDateToField().getDate() != null && this.getDateFromField().getDate().compareTo(this.getDateToField().getDate()) > 0) {
            return this.wordings.errorFromHigherThanTo;
        }
        return null;
    }

    public void clear() {
        this.getDateAll().setSelected(true);
    }

    public void setDates(Date from, Date to) {
        this.dateAll.setSelected(from == null && to == null);
        boolean areEquals = from != null && NullUtils.areEquals(from, to);
        this.dateEquals.setSelected(areEquals);
        this.dateBetween.setSelected(!NullUtils.areEquals(from, to));
        this.dateFrom.setDate(from);
        this.dateTo.setDate(to);
    }

    public Date getDateFrom() {
        if (this.getDateAll().isSelected()) {
            return null;
        }
        return this.getDateFromField().getDate();
    }

    public Date getDateTo() {
        if (this.getDateAll().isSelected()) {
            return null;
        }
        if (this.getDateEquals().isSelected()) {
            return this.getDateFrom();
        }
        return this.getDateToField().getDate();
    }

    public static class Wordings {
        private String title;
        private String all;
        private String allTooltip;
        private String equals;
        private String equalsTooltip;
        private String between;
        private String betweenTooltip;
        private String fromTooltip;
        private String toTooltip;
        private String to;
        private String errorFrom;
        private String errorTo;
        private String errorFromHigherThanTo;

        public Wordings(String title, String all, String allTooltip, String equals, String equalsTooltip, String between, String betweenTooltip, String fromTooltip, String toTooltip, String to, String errorFrom, String errorTo, String errorFromHigherThanTo) {
            this.title = title;
            this.all = all;
            this.allTooltip = allTooltip;
            this.equals = equals;
            this.equalsTooltip = equalsTooltip;
            this.between = between;
            this.betweenTooltip = betweenTooltip;
            this.fromTooltip = fromTooltip;
            this.toTooltip = toTooltip;
            this.to = to;
            this.errorFrom = errorFrom;
            this.errorTo = errorTo;
            this.errorFromHigherThanTo = errorFromHigherThanTo;
        }
    }
}

