/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.widget.ComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.yapbam.data.Alert;
import net.yapbam.gui.LocalizationData;

class AlertsPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel jLabel1 = null;
    private ComboBox alertsMenu = null;
    private Alert[] alerts;

    public AlertsPane() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.ipady = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.ipadx = 0;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints1.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.jLabel1 = new JLabel();
        this.jLabel1.setText(LocalizationData.get("BalanceHistory.alerts"));
        this.add((Component)this.jLabel1, gridBagConstraints1);
        this.setSize(this.getPreferredSize());
        this.add((Component)this.getAlerts(), gridBagConstraints2);
    }

    JComboBox getAlerts() {
        if (this.alertsMenu == null) {
            this.alertsMenu = new ComboBox();
            this.alertsMenu.setToolTipText(LocalizationData.get("BalanceHistory.alerts.toolTip"));
        }
        return this.alertsMenu;
    }

    public void setAlerts(Alert[] alerts) {
        this.alerts = alerts;
        this.setVisible(alerts.length > 0);
        this.alertsMenu.setActionEnabled(false);
        this.alertsMenu.removeAllItems();
        MessageFormat format = Formatter.getMessageFormat(LocalizationData.get("BalanceHistory.alerts.format"));
        for (int i = 0; i < alerts.length; ++i) {
            String balance = LocalizationData.getCurrencyInstance().format(alerts[i].getBalance());
            String threshold = LocalizationData.getCurrencyInstance().format(alerts[i].getThreshold());
            String ope = alerts[i].getKind().equals((Object)Alert.Kind.IS_LESS) ? " < " : " > ";
            String message = format.format(new Object[]{alerts[i].getAccount().getName(), alerts[i].getDate(), balance + ope + threshold});
            this.alertsMenu.addItem(message);
        }
        this.alertsMenu.setActionEnabled(true);
    }

    public Alert getSelectedAlert() {
        return this.alerts[this.alertsMenu.getSelectedIndex()];
    }
}

