/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.util.Date;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import net.yapbam.data.BalanceData;
import net.yapbam.data.Category;
import net.yapbam.data.Mode;
import net.yapbam.data.Transaction;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.graphics.balancehistory.TableSettings;
import net.yapbam.gui.transactiontable.TransactionTableUtils;
import net.yapbam.gui.transactiontable.TransactionsModel;

final class BalanceHistoryModel
extends AbstractTableModel
implements TransactionsModel {
    private static final long serialVersionUID = 1L;
    private BalanceData data;
    private Date endDate;
    private TableSettings settings = new TableSettings();
    private boolean hideIntermediateBalances;
    private int rowCount;

    public BalanceHistoryModel(BalanceData data) {
        this.data = data;
        this.endDate = null;
        this.hideIntermediateBalances = false;
        if (data == null) {
            this.rowCount = 0;
        } else {
            this.rowCount = data.getBalanceHistory().getTransactionsNumber();
            data.addListener(new DataListener(){

                @Override
                public void processEvent(DataEvent event) {
                    BalanceHistoryModel.this.updateRowCount();
                    BalanceHistoryModel.this.fireTableDataChanged();
                }
            });
        }
    }

    void setHideIntermediateBalances(boolean hide) {
        if (hide != this.hideIntermediateBalances) {
            this.hideIntermediateBalances = hide;
            if (this.rowCount != 0) {
                this.fireTableChanged(new TableModelEvent(this, 0, this.rowCount - 1, this.settings.getRemainingColumn(), 0));
            }
        }
    }

    boolean getHideIntermediateBalances() {
        return this.hideIntermediateBalances;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == this.settings.getDateColumn() || columnIndex == this.settings.getValueDateColumn()) {
            return Date.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Transaction transaction = this.getTransaction(rowIndex);
        if (columnIndex == this.settings.getAccountColumn()) {
            return transaction.getAccount().getName();
        }
        if (columnIndex == this.settings.getDateColumn()) {
            return transaction.getDate();
        }
        if (columnIndex == this.settings.getDescriptionColumn()) {
            return TransactionTableUtils.getDescription(transaction, false, !this.settings.isCommentSeparatedFromDescription(), false);
        }
        if (columnIndex == this.settings.getAmountColumn()) {
            return transaction.getAmount();
        }
        if (columnIndex == this.settings.getReceiptColumn()) {
            double[] expenseReceipt = TransactionTableUtils.getExpenseReceipt(transaction, false, false);
            return expenseReceipt == null ? null : Double.valueOf(expenseReceipt[0]);
        }
        if (columnIndex == this.settings.getExpenseColumn()) {
            double[] expenseReceipt = TransactionTableUtils.getExpenseReceipt(transaction, false, true);
            return expenseReceipt == null ? null : Double.valueOf(expenseReceipt[0]);
        }
        if (columnIndex == this.settings.getCategoryColumn()) {
            Category category = transaction.getCategory();
            return category.equals(Category.UNDEFINED) ? LocalizationData.get("Category.undefined") : category.getName();
        }
        if (columnIndex == this.settings.getModeColumn()) {
            Mode mode = transaction.getMode();
            return mode.equals(Mode.UNDEFINED) ? LocalizationData.get("Mode.undefined") : mode.getName();
        }
        if (columnIndex == this.settings.getNumberColumn()) {
            return transaction.getNumber();
        }
        if (columnIndex == this.settings.getValueDateColumn()) {
            return transaction.getValueDate();
        }
        if (columnIndex == this.settings.getStatementColumn()) {
            return transaction.getStatement();
        }
        if (columnIndex == this.settings.getRemainingColumn()) {
            return this.getRemaining(rowIndex);
        }
        if (columnIndex == this.settings.getCommentColumn()) {
            return TransactionTableUtils.getComment(transaction);
        }
        return "?";
    }

    private Double getRemaining(int rowIndex) {
        Transaction transaction;
        Date valueDate = this.getTransaction(rowIndex).getValueDate();
        double balance = this.data.getBalanceHistory().getBalance(valueDate);
        for (int i = rowIndex + 1; i < this.getRowCount() && (transaction = this.getTransaction(i)).getValueDate().equals(valueDate); ++i) {
            balance -= transaction.getAmount();
        }
        return balance;
    }

    @Override
    public Transaction getTransaction(int rowIndex) {
        return this.data.getBalanceHistory().getTransaction(rowIndex);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.settings.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == this.settings.getAccountColumn()) {
            return LocalizationData.get("Transaction.account");
        }
        if (columnIndex == this.settings.getDateColumn()) {
            return LocalizationData.get("Transaction.date");
        }
        if (columnIndex == this.settings.getDescriptionColumn()) {
            return LocalizationData.get("Transaction.description");
        }
        if (columnIndex == this.settings.getAmountColumn()) {
            return LocalizationData.get("Transaction.amount");
        }
        if (columnIndex == this.settings.getCategoryColumn()) {
            return LocalizationData.get("Transaction.category");
        }
        if (columnIndex == this.settings.getModeColumn()) {
            return LocalizationData.get("Transaction.mode");
        }
        if (columnIndex == this.settings.getNumberColumn()) {
            return LocalizationData.get("Transaction.number");
        }
        if (columnIndex == this.settings.getValueDateColumn()) {
            return LocalizationData.get("Transaction.valueDate");
        }
        if (columnIndex == this.settings.getStatementColumn()) {
            return LocalizationData.get("Transaction.statement");
        }
        if (columnIndex == this.settings.getRemainingColumn()) {
            return LocalizationData.get("BalanceHistory.transaction.remainingBalance");
        }
        if (columnIndex == this.settings.getCommentColumn()) {
            return LocalizationData.get("Transaction.comment");
        }
        if (columnIndex == this.settings.getReceiptColumn()) {
            return LocalizationData.get("StatementView.receipt");
        }
        if (columnIndex == this.settings.getExpenseColumn()) {
            return LocalizationData.get("StatementView.debt");
        }
        return "?";
    }

    public int find(Transaction transaction) {
        return this.data.getBalanceHistory().find(transaction);
    }

    public void setEndDate(Date date) {
        if (!NullUtils.areEquals(date, this.endDate)) {
            this.endDate = date;
            this.updateRowCount();
            this.fireTableDataChanged();
        }
    }

    private void updateRowCount() {
        if (this.endDate == null) {
            this.rowCount = this.data.getBalanceHistory().getTransactionsNumber();
        } else {
            this.rowCount = 0;
            for (int i = 0; i < this.data.getBalanceHistory().getTransactionsNumber() && !this.data.getBalanceHistory().getTransaction(i).getValueDate().after(this.endDate); ++i) {
                ++this.rowCount;
            }
        }
    }

    TableSettings getSettings() {
        return this.settings;
    }

    public boolean isDayBalance(int row) {
        Date valueDate = this.getTransaction(row).getValueDate();
        return row == this.getRowCount() - 1 || !this.getTransaction(row + 1).getValueDate().equals(valueDate);
    }

    public Double getDayBalance(int row) {
        return this.data.getBalanceHistory().getBalance(this.getTransaction(row).getValueDate());
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return (columnIndex == this.settings.getDescriptionColumn() || columnIndex == this.settings.getCommentColumn()) && columnIndex >= 0;
    }
}

