/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.Printable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.yapbam.data.Account;
import net.yapbam.data.Alert;
import net.yapbam.data.FilteredData;
import net.yapbam.data.event.AccountAddedEvent;
import net.yapbam.data.event.AccountPropertyChangedEvent;
import net.yapbam.data.event.AccountRemovedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.TransactionsAddedEvent;
import net.yapbam.data.event.TransactionsRemovedEvent;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.actions.CompoundTransactionSelector;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryGraphPane;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryModel;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryTablePane;
import net.yapbam.gui.widget.TabbedPane;

public class BalanceHistoryPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    static final String FIRST_ALERT = "FIRST_ALERT";
    static final String SELECTED_PANEL = "SELECTED_PANEL";
    private JCheckBox ignoreEnd;
    private BalanceHistoryGraphPane graph;
    private Date firstAlert;
    private TabbedPane tabbedPane;
    private FilteredData data;
    private BalanceHistoryTablePane tablePane;
    private int selectedPanel;
    private CompoundTransactionSelector transactionSelector;

    public BalanceHistoryPane(FilteredData data) {
        this.data = data;
        this.graph = new BalanceHistoryGraphPane(data);
        this.setLayout(new BorderLayout(0, 0));
        this.tabbedPane = new TabbedPane();
        final JLayeredPane layered = new JLayeredPane();
        this.add((Component)layered, "Center");
        layered.add(this.tabbedPane);
        layered.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BalanceHistoryPane.this.tabbedPane.setBounds(layered.getBounds());
            }
        });
        this.ignoreEnd = new JCheckBox(LocalizationData.get("BalanceHistory.ignoreEnd"));
        this.ignoreEnd.setToolTipText(LocalizationData.get("BalanceHistory.ignoreEnd.toolTip"));
        this.ignoreEnd.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BalanceHistoryPane.this.graph.setIgnoreEnd(BalanceHistoryPane.this.ignoreEnd.isSelected());
                BalanceHistoryPane.this.setTableEnd();
            }
        });
        layered.add((Component)this.ignoreEnd, JLayeredPane.MODAL_LAYER);
        final int margin = (int)(Preferences.INSTANCE.getFontSizeRatio() * 3.0f);
        this.tabbedPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Rectangle bounds = BalanceHistoryPane.this.tabbedPane.getBounds();
                Dimension preferredSize = BalanceHistoryPane.this.ignoreEnd.getPreferredSize();
                bounds.x = bounds.width - preferredSize.width - margin;
                bounds.y = margin;
                bounds.width = preferredSize.width;
                bounds.height = preferredSize.height;
                BalanceHistoryPane.this.ignoreEnd.setBounds(bounds);
            }
        });
        this.tabbedPane.addTab(LocalizationData.get("BalanceHistory.graph.title"), null, this.graph, LocalizationData.get("BalanceHistory.graph.toolTip"));
        data.addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (event instanceof EverythingChangedEvent) {
                    BalanceHistoryPane.this.ignoreEnd.setVisible(BalanceHistoryPane.this.data.getFilter().getValueDateTo() != null);
                }
            }
        });
        data.getGlobalData().addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (event instanceof EverythingChangedEvent || event instanceof AccountAddedEvent || event instanceof AccountRemovedEvent || event instanceof AccountPropertyChangedEvent || event instanceof TransactionsAddedEvent || event instanceof TransactionsRemovedEvent) {
                    BalanceHistoryPane.this.testAlert();
                }
            }
        });
        this.testAlert();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BalanceHistoryPane.this.changeDisplayed();
            }
        });
        this.tablePane = new BalanceHistoryTablePane(data);
        this.tabbedPane.addTab(LocalizationData.get("BalanceHistory.transaction.title"), null, this.tablePane, LocalizationData.get("BalanceHistory.transaction.tooltip"));
        this.transactionSelector = new CompoundTransactionSelector(data);
        this.setTableEnd();
        this.ignoreEnd.setVisible(this.data.getFilter().getValueDateTo() != null);
    }

    void changeDisplayed() {
        int selected = this.tabbedPane.getId(this.tabbedPane.getSelectedIndex());
        if (selected == 0) {
            this.graph.scrollToSelectedDate();
        }
        if (selected != this.selectedPanel) {
            int old = this.selectedPanel;
            this.selectedPanel = selected;
            this.firePropertyChange(SELECTED_PANEL, old, this.selectedPanel);
        }
        this.transactionSelector.setInternalSelector(selected == 0 ? null : this.tablePane.table);
    }

    private void testAlert() {
        Date today = new Date();
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        for (int i = 0; i < this.data.getGlobalData().getAccountsNumber(); ++i) {
            Account account = this.data.getGlobalData().getAccount(i);
            Alert alert = account.getFirstAlert(today, null);
            if (alert == null) continue;
            alerts.add(alert);
        }
        this.graph.setAlerts(alerts.toArray(new Alert[alerts.size()]));
        Date first = null;
        for (int i = 0; i < alerts.size(); ++i) {
            if (first != null && ((Alert)alerts.get(i)).getDate().compareTo(first) >= 0) continue;
            first = ((Alert)alerts.get(i)).getDate();
        }
        this.setFirstAlert(first);
    }

    private void setFirstAlert(Date first) {
        if (!NullUtils.areEquals(first, this.firstAlert)) {
            Date old = this.firstAlert;
            this.firstAlert = first;
            int index = this.tabbedPane.getIndexOf(0);
            this.tabbedPane.setIconAt(index, first != null ? IconManager.get(IconManager.Name.ALERT) : null);
            String tooltip = LocalizationData.get("BalanceHistory.graph.toolTip");
            if (first != null) {
                String dateStr = DateFormat.getDateInstance(3, LocalizationData.getLocale()).format(first);
                tooltip = tooltip.replace("'", "''");
                String pattern = "<html>" + tooltip + "<br>" + LocalizationData.get("BalanceHistory.alertTooltipAdd") + "</html>";
                tooltip = Formatter.format(pattern, "<b>" + dateStr + "</b>");
            }
            this.tabbedPane.setToolTipTextAt(index, tooltip);
            this.firePropertyChange(FIRST_ALERT, old, this.firstAlert);
        }
    }

    public Date getFirstAlert() {
        return this.firstAlert;
    }

    public void saveState() {
        YapbamState.INSTANCE.saveState(this.tabbedPane, this.getClass().getCanonicalName());
        YapbamState.INSTANCE.put(this.getClass().getCanonicalName() + ".ignoreEnd", Boolean.toString(this.ignoreEnd.isSelected()));
        this.tablePane.saveState();
        this.graph.saveState();
    }

    public void restoreState() {
        this.graph.restoreState();
        this.tablePane.restoreState();
        YapbamState.INSTANCE.restoreState(this.tabbedPane, this.getClass().getCanonicalName());
        this.ignoreEnd.setSelected(Boolean.parseBoolean(YapbamState.INSTANCE.get(this.getClass().getCanonicalName() + ".ignoreEnd", "true")));
    }

    public Printable getPrintable() {
        return this.tablePane.getPrintable();
    }

    TransactionSelector getTransactionSelector() {
        return this.transactionSelector;
    }

    private void setTableEnd() {
        ((BalanceHistoryModel)this.tablePane.table.getModel()).setEndDate(this.ignoreEnd.isSelected() ? null : this.data.getFilter().getValueDateTo());
    }
}

