/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import net.yapbam.data.Account;
import net.yapbam.data.AlertThreshold;
import net.yapbam.data.FilteredData;
import net.yapbam.data.event.AccountPropertyChangedEvent;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.gui.graphics.balancehistory.BalanceHistoryModel;
import net.yapbam.gui.graphics.balancehistory.TablePreferencePanel;
import net.yapbam.gui.transactiontable.TransactionTablePainter;

final class BalanceHistoryTablePainter
extends TransactionTablePainter {
    private static final long serialVersionUID = 1L;
    private Color alertColor = TablePreferencePanel.isHighlightAlerts() ? new Color(255, 100, 100) : null;
    private AlertThreshold alertThreshold;
    private FilteredData data;

    BalanceHistoryTablePainter(FilteredData data) {
        this.data = data;
        this.refreshMinMax();
        data.addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                boolean needRefresh;
                boolean bl = needRefresh = event instanceof EverythingChangedEvent || event instanceof AccountPropertyChangedEvent;
                if (needRefresh) {
                    BalanceHistoryTablePainter.this.refreshMinMax();
                }
            }
        });
    }

    private void refreshMinMax() {
        Account singleAccount = null;
        if (this.data.getGlobalData().getAccountsNumber() == 1) {
            singleAccount = this.data.getGlobalData().getAccount(0);
        } else {
            List<Account> validAccounts = this.data.getFilter().getValidAccounts();
            if (validAccounts != null && validAccounts.size() == 1) {
                singleAccount = validAccounts.get(0);
            }
        }
        this.alertThreshold = singleAccount == null ? new AlertThreshold(0.0, Double.MAX_VALUE) : singleAccount.getAlertThreshold();
    }

    @Override
    public void setRowLook(Component renderer, JTable table, int row, boolean isSelected) {
        super.setRowLook(renderer, table, row, isSelected);
        BalanceHistoryModel model = (BalanceHistoryModel)table.getModel();
        if (this.alertColor != null && !isSelected && this.alertThreshold.getTrigger(model.getDayBalance(row)) != 0) {
            renderer.setBackground(this.alertColor);
        }
    }
}

