/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.graphics.balancehistory;

import com.fathzer.jlocal.Formatter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.preferences.PreferencePanel;

final class TablePreferencePanel
extends PreferencePanel {
    private static final long serialVersionUID = 1L;
    private static final String SAME_COLORS = "SameColorsAsTransactionsTab";
    private static final String HIGHLIGHT_ALERTS = "HighlightAlerts";
    private static final String SEPARATE_EXPENSE_RECEIPT = "SeparateExpenseReceipt";
    private JCheckBox chckbxUseSameColors;
    private JCheckBox chckbxHilightAlerts;
    private JCheckBox chckbxSeparateExpenseReceipt;

    public TablePreferencePanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcChckbxHilightAlerts = new GridBagConstraints();
        gbcChckbxHilightAlerts.anchor = 17;
        gbcChckbxHilightAlerts.insets = new Insets(5, 5, 5, 0);
        gbcChckbxHilightAlerts.gridx = 0;
        gbcChckbxHilightAlerts.gridy = 0;
        this.add((Component)this.getChckbxHilightAlerts(), gbcChckbxHilightAlerts);
        GridBagConstraints gbcChckbxSeparateExpenseReceipt = new GridBagConstraints();
        gbcChckbxSeparateExpenseReceipt.anchor = 17;
        gbcChckbxSeparateExpenseReceipt.insets = new Insets(0, 5, 5, 0);
        gbcChckbxSeparateExpenseReceipt.gridx = 0;
        gbcChckbxSeparateExpenseReceipt.gridy = 1;
        this.add((Component)this.getChckbxSeparateExpenseReceipt(), gbcChckbxSeparateExpenseReceipt);
        GridBagConstraints gbcChckbxUseSameColors = new GridBagConstraints();
        gbcChckbxUseSameColors.insets = new Insets(0, 5, 0, 0);
        gbcChckbxUseSameColors.weightx = 1.0;
        gbcChckbxUseSameColors.weighty = 1.0;
        gbcChckbxUseSameColors.anchor = 18;
        gbcChckbxUseSameColors.gridx = 0;
        gbcChckbxUseSameColors.gridy = 2;
        this.add((Component)this.getChckbxUseSameColors(), gbcChckbxUseSameColors);
    }

    public static boolean isSameColors() {
        return Boolean.parseBoolean(Preferences.INSTANCE.getProperty(SAME_COLORS));
    }

    public static boolean isHighlightAlerts() {
        return Boolean.parseBoolean(Preferences.INSTANCE.getProperty(HIGHLIGHT_ALERTS, "true"));
    }

    public static boolean isReceiptSeparatedFromExpense() {
        return Boolean.parseBoolean(Preferences.INSTANCE.getProperty(SEPARATE_EXPENSE_RECEIPT, "false"));
    }

    @Override
    public boolean updatePreferences() {
        boolean isSameColors = this.getChckbxUseSameColors().isSelected();
        boolean isHighlightAlerts = this.getChckbxHilightAlerts().isSelected();
        boolean separateExpenseReceipt = this.getChckbxSeparateExpenseReceipt().isSelected();
        if (isSameColors == TablePreferencePanel.isSameColors() && isHighlightAlerts == TablePreferencePanel.isHighlightAlerts() && separateExpenseReceipt == TablePreferencePanel.isReceiptSeparatedFromExpense()) {
            return false;
        }
        Preferences.INSTANCE.setProperty(SAME_COLORS, Boolean.toString(isSameColors));
        Preferences.INSTANCE.setProperty(HIGHLIGHT_ALERTS, Boolean.toString(isHighlightAlerts));
        Preferences.INSTANCE.setProperty(SEPARATE_EXPENSE_RECEIPT, Boolean.toString(separateExpenseReceipt));
        return true;
    }

    @Override
    public String getToolTip() {
        return LocalizationData.get("BalanceHistory.prefs.title");
    }

    @Override
    public String getTitle() {
        return LocalizationData.get("BalanceHistory.title");
    }

    private JCheckBox getChckbxUseSameColors() {
        if (this.chckbxUseSameColors == null) {
            String tab = LocalizationData.get("MainFrame.Transactions");
            String title = Formatter.format(LocalizationData.get("BalanceHistory.prefs.sameBackgroundAsTransactionTable"), tab);
            this.chckbxUseSameColors = new JCheckBox(title);
            String tip = Formatter.format(LocalizationData.get("BalanceHistory.prefs.sameBackgroundAsTransactionTable.tooltip"), tab);
            this.chckbxUseSameColors.setToolTipText(tip);
            this.chckbxUseSameColors.setSelected(TablePreferencePanel.isSameColors());
        }
        return this.chckbxUseSameColors;
    }

    private JCheckBox getChckbxHilightAlerts() {
        if (this.chckbxHilightAlerts == null) {
            this.chckbxHilightAlerts = new JCheckBox(LocalizationData.get("BalanceHistory.prefs.highlightAlerts"));
            this.chckbxHilightAlerts.setToolTipText(LocalizationData.get("BalanceHistory.prefs.highlightAlerts.tooltip"));
            this.chckbxHilightAlerts.setSelected(TablePreferencePanel.isHighlightAlerts());
        }
        return this.chckbxHilightAlerts;
    }

    private JCheckBox getChckbxSeparateExpenseReceipt() {
        if (this.chckbxSeparateExpenseReceipt == null) {
            this.chckbxSeparateExpenseReceipt = new JCheckBox(LocalizationData.get("MainFrame.Transactions.Preferences.separateExpenseReceipt"));
            this.chckbxSeparateExpenseReceipt.setToolTipText(LocalizationData.get("MainFrame.Transactions.Preferences.separateExpenseReceipt.tooltip"));
            this.chckbxSeparateExpenseReceipt.setSelected(TablePreferencePanel.isReceiptSeparatedFromExpense());
        }
        return this.chckbxSeparateExpenseReceipt;
    }
}

