/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.info;

import com.fathzer.jlocal.Formatter;
import net.yapbam.gui.info.MessagesHistory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.LoggerFactory;

class Message {
    private static final String KIND_ATTR = "kind";
    private static final String IGNORE_TIME_ATTR = "ignoreTime";
    private static final String PARAMS_ATTR = "parameters";
    private static final String TEXT_ATTR = "text";
    private static final String ID_ATTR = "id";
    private Kind kind;
    private String id;
    private String content;
    private String[] parameters;
    private long maxIgnoreTime;

    Message(String id, String kind, String content) {
        this.id = id;
        this.kind = "news".equals(kind) ? Kind.INFO : ("warning".equals(kind) ? Kind.WARNING : null);
        this.content = content;
        this.parameters = new String[0];
        this.maxIgnoreTime = Long.MAX_VALUE;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getContent() {
        if (this.parameters == null) {
            return this.content;
        }
        return Formatter.format(this.content, this.parameters);
    }

    private static boolean isMessage(JSONObject obj) {
        Object kind = obj.get(KIND_ATTR);
        return "news".equals(kind) || "warning".equals(kind);
    }

    public static Message build(JSONObject obj) {
        if ("arguments".equals(obj.get(KIND_ATTR))) {
            LoggerFactory.getLogger(Message.class).info("Input: {}", (Object)obj);
            return null;
        }
        if (!(Message.isMessage(obj) && obj.get(ID_ATTR) instanceof String && obj.get(TEXT_ATTR) instanceof String)) {
            LoggerFactory.getLogger(Message.class).info("Unexpected JSON object: {}", (Object)obj);
            return null;
        }
        Message result = new Message((String)obj.get(ID_ATTR), (String)obj.get(KIND_ATTR), (String)obj.get(TEXT_ATTR));
        if (obj.get(IGNORE_TIME_ATTR) instanceof Long) {
            result.maxIgnoreTime = (Long)obj.get(IGNORE_TIME_ATTR);
        }
        if (obj.get(PARAMS_ATTR) instanceof JSONArray) {
            JSONArray array = (JSONArray)obj.get(PARAMS_ATTR);
            String[] params = new String[array.size()];
            boolean ok = true;
            for (int i = 0; i < params.length; ++i) {
                if (!(array.get(i) instanceof String)) {
                    ok = false;
                    break;
                }
                params[i] = (String)array.get(i);
            }
            if (ok) {
                result.parameters = params;
            }
        }
        return result;
    }

    public void markRead() {
        MessagesHistory.setReadTime(this, System.currentTimeMillis());
    }

    public boolean isRead() {
        long readTime = MessagesHistory.getReadTime(this);
        if (readTime <= 0L) {
            return false;
        }
        long ms = System.currentTimeMillis() - readTime;
        long days = ms / 86400000L;
        return days <= this.maxIgnoreTime;
    }

    String getId() {
        return this.id;
    }

    public String toString() {
        return "[" + this.getId() + " (" + (this.isRead() ? "read" : "unread") + ")]";
    }

    static enum Kind {
        INFO,
        WARNING;

    }
}

