/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.persistence.reading;

import com.fathzer.soft.ajlib.swing.worker.Worker;
import com.fathzer.soft.jclop.Cancellable;
import com.fathzer.soft.jclop.Service;
import com.fathzer.soft.jclop.SynchronizationState;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Locale;
import net.yapbam.data.xml.YapbamSerializer;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.persistence.CancelManager;
import net.yapbam.gui.persistence.DataWrapper;
import net.yapbam.gui.persistence.SynchronizeCommand;
import net.yapbam.gui.persistence.reading.ReaderResult;
import net.yapbam.gui.persistence.reading.State;

class SyncAndReadWorker
extends Worker<ReaderResult, Void>
implements Cancellable {
    private URI uri;
    private Object data;
    private DataWrapper<?> dataAdapter;
    private boolean isSynchronizing;
    private SynchronizeCommand command;
    private CancelManager cancelManager;
    private Service service;
    private Locale locale;

    SyncAndReadWorker(Service service, DataWrapper<?> dataAdapter, URI uri, SynchronizeCommand command) {
        this.service = service;
        this.dataAdapter = dataAdapter;
        this.uri = uri;
        this.data = null;
        this.command = command;
        this.locale = LocalizationData.getLocale();
        this.cancelManager = new CancelManager(this);
    }

    @Override
    protected ReaderResult doProcessing() throws Exception {
        SynchronizationState syncState;
        if ("classpath".equals(this.uri.getScheme())) {
            this.data = YapbamSerializer.read(this.uri, null, null);
            return new ReaderResult(State.FINISHED, SynchronizationState.SYNCHRONIZED);
        }
        if (!this.command.equals((Object)SynchronizeCommand.NOTHING)) {
            block12: {
                this.isSynchronizing = true;
                try {
                    if (this.command.equals((Object)SynchronizeCommand.SYNCHRONIZE)) {
                        this.setPhase(LocalizationData.get("synchronization.synchronizing"), -1);
                        syncState = this.service.synchronize(this.uri, this, this.locale);
                        break block12;
                    }
                    if (this.command.equals((Object)SynchronizeCommand.UPLOAD)) {
                        this.setPhase(LocalizationData.get("synchronization.uploading"), -1);
                        this.service.upload(this.uri, this, this.locale);
                        syncState = SynchronizationState.SYNCHRONIZED;
                        break block12;
                    }
                    if (this.command.equals((Object)SynchronizeCommand.DOWNLOAD)) {
                        this.setPhase(LocalizationData.get("synchronization.downloading"), -1);
                        this.service.download(this.uri, this, this.locale);
                        syncState = SynchronizationState.SYNCHRONIZED;
                        break block12;
                    }
                    throw new IllegalArgumentException((Object)((Object)this.command) + " is unknown");
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    return new ReaderResult(State.EXCEPTION_WHILE_SYNC, null, e);
                }
            }
            if (this.isCancelled()) {
                return null;
            }
        } else {
            syncState = SynchronizationState.SYNCHRONIZED;
        }
        this.isSynchronizing = false;
        if (syncState.equals((Object)SynchronizationState.SYNCHRONIZED)) {
            File localURI = this.service.getLocalFile(this.uri);
            boolean passwordRequired = this.dataAdapter.needPassword(localURI);
            if (passwordRequired) {
                return new ReaderResult(State.NEED_PASSWORD, syncState);
            }
            this.setPhase(MessageFormat.format(LocalizationData.get("Generic.wait.readingFrom"), this.service.getDisplayable(this.uri)), -1);
            this.data = this.dataAdapter.deserialize(localURI, null, this.service, this);
            return new ReaderResult(State.FINISHED, syncState);
        }
        return new ReaderResult(State.REQUEST_USER, syncState);
    }

    @Override
    public void reportProgress(int progress) {
        super.reportProgress(progress);
    }

    @Override
    public void setPhase(String phase, int length) {
        super.setPhase(phase, length);
    }

    @Override
    public void setMax(int length) {
        super.setPhase(this.getPhase(), length);
    }

    public Object getData() {
        return this.data;
    }

    public boolean isSynchronizing() {
        return this.isSynchronizing;
    }

    @Override
    public void setCancelAction(Runnable action) {
        this.cancelManager.setAction(action);
    }
}

