/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.persistence.writing;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.worker.WorkInProgressFrame;
import com.fathzer.soft.ajlib.utilities.FileUtils;
import com.fathzer.soft.jclop.SynchronizationState;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.persistence.DataWrapper;
import net.yapbam.gui.persistence.PersistenceAdapter;
import net.yapbam.gui.persistence.PersistenceManager;
import net.yapbam.gui.persistence.SynchronizeCommand;
import net.yapbam.gui.persistence.reading.DataReader;
import net.yapbam.gui.persistence.writing.SaveWorker;
import net.yapbam.gui.persistence.writing.SynchronizeWorker;
import net.yapbam.gui.persistence.writing.WriterResult;
import net.yapbam.util.Portable;

public class DataWriter {
    private Window owner;
    private DataWrapper<?> data;
    private URI uri;
    private PersistenceAdapter adapter;
    private PersistenceManager manager;

    public DataWriter(PersistenceManager manager, Window owner, DataWrapper<?> data, URI uri) {
        this.owner = owner;
        this.data = data;
        this.uri = uri;
        this.manager = manager;
        this.adapter = manager.getAdapter(uri);
    }

    public boolean save() {
        if ("file".equals(this.uri.getScheme()) && FileUtils.isIncluded(new File(this.uri), Portable.getApplicationDirectory())) {
            Object[] options = new Object[]{LocalizationData.get("GenericButton.cancel"), LocalizationData.get("GenericButton.continue")};
            String message = LocalizationData.get("saveDialog.dangerousLocation.message");
            int choice = JOptionPane.showOptionDialog(this.owner, message, LocalizationData.get("Generic.warning"), 0, 2, null, options, options[0]);
            if (choice == 0) {
                return false;
            }
        }
        SaveWorker worker = new SaveWorker(this.manager, this.data, this.uri);
        WorkInProgressFrame waitFrame = this.manager.buildWaitDialog(this.owner, worker);
        waitFrame.setVisible(true);
        try {
            WriterResult result = (WriterResult)worker.get();
            if (result == null) {
                return false;
            }
            this.data.setURI(this.uri);
            this.data.setUnchanged();
            if (result.getState().equals((Object)WriterResult.State.EXCEPTION_WHILE_SYNC)) {
                if (result.getException() instanceof IOException) {
                    result.getException().printStackTrace();
                } else {
                    ErrorManager.INSTANCE.log(this.owner, result.getException());
                }
            } else {
                SynchronizationState state = result.getSyncState();
                if (state.equals((Object)SynchronizationState.REMOTE_DELETED)) {
                    this.doRemoteDeleted();
                } else if (state.equals((Object)SynchronizationState.CONFLICT)) {
                    this.doConflict();
                }
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                JOptionPane.showMessageDialog(this.owner, LocalizationData.get("saveDialog.fileNotWritable"), LocalizationData.get("Generic.error"), 0);
            } else {
                ErrorManager.INSTANCE.log(this.owner, e.getCause());
            }
            return false;
        }
        catch (CancellationException e) {
            this.data.setURI(this.uri);
            this.data.setUnchanged();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private void doRemoteDeleted() throws ExecutionException {
        String message = Formatter.format(LocalizationData.get("synchronization.question.other"), this.adapter.getMessage("com.fathzer.soft.jclop.remoteMissing"));
        Object[] options = new Object[]{this.adapter.getMessage("com.fathzer.soft.jclop.upload"), LocalizationData.get("synchronization.deleteCache.action"), LocalizationData.get("GenericButton.cancel")};
        int n = JOptionPane.showOptionDialog(this.owner, message, LocalizationData.get("Generic.warning"), 1, 3, null, options, options[2]);
        if (n != 2) {
            if (n == 0) {
                this.doSync(SynchronizeCommand.UPLOAD);
            } else {
                this.adapter.getService().deleteLocal(this.uri);
            }
        }
    }

    private void doConflict() throws ExecutionException {
        String message = Formatter.format(LocalizationData.get("synchronization.question.other"), this.adapter.getMessage("com.fathzer.soft.jclop.conflict"));
        Object[] options = new Object[]{this.adapter.getMessage("com.fathzer.soft.jclop.upload"), this.adapter.getMessage("com.fathzer.soft.jclop.download"), LocalizationData.get("GenericButton.cancel")};
        int n = JOptionPane.showOptionDialog(this.owner, message, LocalizationData.get("Generic.warning"), 1, 3, null, options, options[2]);
        if (n != 2) {
            if (n == 0) {
                this.doSync(SynchronizeCommand.UPLOAD);
            } else {
                this.doSync(SynchronizeCommand.DOWNLOAD);
            }
        }
    }

    private void doSync(SynchronizeCommand command) throws ExecutionException {
        SynchronizeWorker worker = new SynchronizeWorker(this.adapter.getService(), this.uri, command, LocalizationData.getLocale());
        WorkInProgressFrame waitFrame = this.manager.buildWaitDialog(this.owner, worker);
        waitFrame.setVisible(true);
        if (command.equals((Object)SynchronizeCommand.DOWNLOAD) && !worker.isCancelled()) {
            this.data.clear();
            new DataReader(this.manager, this.owner, this.data, this.uri).doSyncAndRead(SynchronizeCommand.NOTHING);
        }
    }
}

