/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.persistence.writing;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.worker.Worker;
import com.fathzer.soft.jclop.Cancellable;
import com.fathzer.soft.jclop.Service;
import com.fathzer.soft.jclop.SynchronizationState;
import java.io.File;
import java.net.URI;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.persistence.CancelManager;
import net.yapbam.gui.persistence.DataWrapper;
import net.yapbam.gui.persistence.PersistenceManager;
import net.yapbam.gui.persistence.writing.WriterResult;

class SaveWorker
extends Worker<WriterResult, Void>
implements Cancellable {
    private PersistenceManager manager;
    private DataWrapper<?> data;
    private URI uri;
    private CancelManager cancelManager;

    SaveWorker(PersistenceManager manager, DataWrapper<?> data, URI uri) {
        this.manager = manager;
        this.data = data;
        this.uri = uri;
        this.cancelManager = new CancelManager(this);
    }

    @Override
    protected WriterResult doProcessing() throws Exception {
        this.setPhase(Formatter.format(LocalizationData.get("Generic.wait.writingTo"), this.uri.getPath()), -1);
        Service service = this.manager.getAdapter(this.uri).getService();
        File previousFile = service.getLocalFile(this.uri);
        File file = service.getLocalFileForWriting(this.uri);
        Boolean deleteOnCancelled = !file.exists();
        this.data.serialize(file, service, this);
        if (this.isCancelled()) {
            if (deleteOnCancelled.booleanValue()) {
                file.delete();
            }
            return null;
        }
        if (!previousFile.equals(file)) {
            previousFile.delete();
        }
        if (service.isLocal()) {
            return new WriterResult(WriterResult.State.FINISHED, SynchronizationState.SYNCHRONIZED, null);
        }
        try {
            this.setPhase(LocalizationData.get("synchronization.synchronizing"), -1);
            SynchronizationState state = service.synchronize(this.uri, this, LocalizationData.getLocale());
            return new WriterResult(WriterResult.State.FINISHED, state, null);
        }
        catch (Exception e) {
            return new WriterResult(WriterResult.State.EXCEPTION_WHILE_SYNC, null, e);
        }
    }

    @Override
    public void reportProgress(int progress) {
        super.reportProgress(progress);
    }

    @Override
    public void setPhase(String phase, int length) {
        super.setPhase(phase, length);
    }

    @Override
    public void setCancelAction(Runnable action) {
        this.cancelManager.setAction(action);
    }

    @Override
    public void setMax(int max) {
        super.setPhaseLength(max);
    }
}

