/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statementview;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import net.yapbam.data.Transaction;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.TransactionSelector;
import net.yapbam.gui.actions.AbstractTransactionAction;
import net.yapbam.gui.statementview.StatementViewPanel;
import net.yapbam.gui.statementview.TransactionsUpdater;

public class CheckTransactionAction
extends AbstractTransactionAction {
    private static final long serialVersionUID = 1L;
    private StatementViewPanel tPanel;
    private TransactionSelector destSelector;
    private TransactionsUpdater updater = new TransactionsUpdater(){

        @Override
        protected Transaction update(Transaction t) {
            String statementId = null;
            if (t.getStatement() == null) {
                statementId = CheckTransactionAction.this.tPanel.getEditedStatement();
            }
            return new Transaction(t.getDate(), t.getNumber(), t.getDescription(), t.getComment(), t.getAmount(), t.getAccount(), t.getMode(), t.getCategory(), t.getValueDate(), statementId, Arrays.asList(t.getSubTransactions()));
        }
    };

    public CheckTransactionAction(StatementViewPanel statementViewPanel, TransactionSelector selector, TransactionSelector destSelector, boolean check) {
        super(selector, check ? LocalizationData.get("MainMenu.Transactions.Check") : LocalizationData.get("MainMenu.Transactions.Uncheck"), IconManager.get(check ? IconManager.Name.CHECK_TRANSACTION : IconManager.Name.UNCHECK_TRANSACTION), check ? LocalizationData.get("MainMenu.Transactions.Check.ToolTip") : LocalizationData.get("MainMenu.Transactions.Uncheck.ToolTip"));
        if (check) {
            this.putValue("MnemonicKey", LocalizationData.getChar("MainMenu.Transactions.Check.Mnemonic"));
        }
        this.tPanel = statementViewPanel;
        this.destSelector = destSelector;
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CheckTransactionAction.this.updateEnabled();
            }
        };
        if (statementViewPanel != null) {
            statementViewPanel.addPropertyChangeListener("CheckModeReady", listener);
        }
        this.updateEnabled();
    }

    @Override
    public void updateEnabled() {
        boolean isEnabled;
        boolean bl = isEnabled = this.selector.getSelectedTransactions().length > 0;
        if (this.tPanel != null) {
            isEnabled = isEnabled && this.tPanel.isCheckModeReady();
        }
        this.setEnabled(isEnabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Transaction[] update = this.updater.update(this.selector);
        this.destSelector.setSelectedTransactions(update);
    }
}

